/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.system;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.Map;
import org.seasar.system.RMIAdaptor;
import org.seasar.system.RMIAdaptorService;
import org.seasar.system.RMIConnector;
import org.seasar.util.Reflector;
import org.seasar.util.SMap;
import org.seasar.util.SeasarContext;
import org.seasar.util.SeasarException;

public final class MBeanProxy
implements InvocationHandler,
Externalizable {
    static final long serialVersionUID = 4230846384158691664L;
    private static transient Map _sigsMap = new SMap();
    private transient String _name;
    private transient String _hostName;
    private transient int _port;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$seasar$system$MBeanProxy;

    public static Object create(Class mbeanInterface, String name) throws SeasarException {
        return Proxy.newProxyInstance(mbeanInterface.getClassLoader(), new Class[]{mbeanInterface}, (InvocationHandler)new MBeanProxy(name));
    }

    public static Object create(Class mbeanInterface, String name, SeasarContext seasarContext) throws SeasarException {
        return MBeanProxy.create(mbeanInterface, name, seasarContext.getHostName(), seasarContext.getPort());
    }

    public static Object create(Class mbeanInterface, String name, String url) throws SeasarException {
        if (url != null && url.length() > 0) {
            String host = null;
            int port = 1108;
            int colonPos = url.lastIndexOf(58);
            int slashPos = url.lastIndexOf(47);
            if (slashPos >= 0) {
                if (colonPos > slashPos) {
                    host = url.substring(slashPos + 1, colonPos);
                    port = Integer.parseInt(url.substring(colonPos + 1));
                } else {
                    host = url.substring(slashPos + 1);
                }
            } else if (colonPos > 0) {
                host = url.substring(0, colonPos);
                port = Integer.parseInt(url.substring(colonPos + 1));
            } else {
                host = url;
            }
            return MBeanProxy.create(mbeanInterface, name, host, port);
        }
        return MBeanProxy.create(mbeanInterface, name);
    }

    public static Object create(Class mbeanInterface, String name, String host, int port) {
        return Proxy.newProxyInstance(mbeanInterface.getClassLoader(), new Class[]{mbeanInterface}, (InvocationHandler)new MBeanProxy(name, host, port));
    }

    public MBeanProxy() {
    }

    private MBeanProxy(String name) {
        this._name = name;
        this._hostName = RMIAdaptorService.getInstance().getHostName();
        this._port = RMIAdaptorService.getInstance().getPort();
    }

    private MBeanProxy(String name, String hostName, int port) {
        this._name = name;
        this._hostName = hostName;
        this._port = port;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().equals(class$java$lang$Object == null ? (class$java$lang$Object = MBeanProxy.class$("java.lang.Object")) : class$java$lang$Object)) {
            return Reflector.invoke(method, this, args);
        }
        String[] sigs = MBeanProxy.getSigs(method);
        RMIAdaptor rmiAdaptor = RMIConnector.getRMIAdaptor(this._hostName, this._port);
        try {
            return rmiAdaptor.invoke(this._name, method.getName(), args, sigs);
        }
        catch (RemoteException ex) {
            rmiAdaptor = RMIConnector.regetRMIAdaptor(this._hostName, this._port);
            return rmiAdaptor.invoke(this._name, method.getName(), args, sigs);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._name);
        out.writeObject(this._hostName);
        out.writeInt(this._port);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._name = (String)in.readObject();
        this._hostName = (String)in.readObject();
        this._port = in.readInt();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (Proxy.isProxyClass(o.getClass())) {
            o = Proxy.getInvocationHandler(o);
        }
        return this == o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getSigs(Method method) {
        String[] sigs = (String[])_sigsMap.get(method);
        if (sigs != null) {
            return sigs;
        }
        Class clazz = class$org$seasar$system$MBeanProxy == null ? (class$org$seasar$system$MBeanProxy = MBeanProxy.class$("org.seasar.system.MBeanProxy")) : class$org$seasar$system$MBeanProxy;
        synchronized (clazz) {
            sigs = (String[])_sigsMap.get(method);
            if (sigs == null) {
                Class<?>[] types = method.getParameterTypes();
                sigs = new String[types.length];
                for (int i = 0; i < types.length; ++i) {
                    sigs[i] = types[i].getName();
                }
                _sigsMap.put(method, sigs);
            }
        }
        return sigs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

