/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.system;

import java.lang.reflect.Method;
import java.util.Map;
import org.seasar.system.JMXUtil;
import org.seasar.util.EMap;
import org.seasar.util.SeasarException;
import org.seasar.util.SeasarRuntimeException;

public final class MBeanMetaData {
    private static Map _mbeanMetaDataMap = new EMap();
    private Class _mbeanClass;
    private Class _mbeanInterface;
    private Map _methodMap = new EMap();

    private MBeanMetaData(Class mbeanClass, Class mbeanInterface) {
        this._mbeanClass = mbeanClass;
        this._mbeanInterface = mbeanInterface;
        this.createMethodMap();
    }

    public static void checkCompliance(Class mbeanClass) throws SeasarException {
        MBeanMetaData.getInstance(mbeanClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanMetaData getInstance(Class mbeanClass) throws SeasarException {
        MBeanMetaData mbeanMetaData = (MBeanMetaData)_mbeanMetaDataMap.get(mbeanClass);
        if (mbeanMetaData != null) {
            return mbeanMetaData;
        }
        Map map = _mbeanMetaDataMap;
        synchronized (map) {
            mbeanMetaData = (MBeanMetaData)_mbeanMetaDataMap.get(mbeanClass);
            if (mbeanMetaData == null) {
                mbeanMetaData = MBeanMetaData.createMBeanMetaData(mbeanClass);
                _mbeanMetaDataMap.put(mbeanClass, mbeanMetaData);
            }
        }
        return mbeanMetaData;
    }

    public static String getMethodSignature(Method method) {
        StringBuffer buf = new StringBuffer(method.getName());
        buf.append("(");
        Class<?>[] paraTypes = method.getParameterTypes();
        if (paraTypes != null) {
            for (int i = 0; i < paraTypes.length; ++i) {
                buf.append(paraTypes[i].getName());
                buf.append(";");
            }
        }
        buf.append(")");
        return buf.toString();
    }

    public static String getMethodSignature(String methodName, String[] signatures) {
        StringBuffer buf = new StringBuffer(methodName);
        buf.append("(");
        if (signatures != null) {
            for (int i = 0; i < signatures.length; ++i) {
                buf.append(signatures[i]);
                buf.append(";");
            }
        }
        buf.append(")");
        return buf.toString();
    }

    public Method getMethod(String methodName, String[] signatures) {
        String sig = MBeanMetaData.getMethodSignature(methodName, signatures);
        Method m = (Method)this._methodMap.get(sig);
        if (m == null) {
            throw new SeasarRuntimeException("ESSR0001", new Object[]{sig});
        }
        return m;
    }

    private static MBeanMetaData createMBeanMetaData(Class mbeanClass) throws SeasarException {
        Class mbeanInterface = JMXUtil.getMBeanInterface(mbeanClass);
        if (mbeanInterface == null) {
            throw new SeasarException("ESSR0338", new Object[]{mbeanClass.getName()});
        }
        return new MBeanMetaData(mbeanClass, mbeanInterface);
    }

    private void createMethodMap() {
        Method[] methods = this._mbeanInterface.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            this._methodMap.put(MBeanMetaData.getMethodSignature(methods[i]), methods[i]);
        }
    }
}

