/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.system;

import java.lang.reflect.Proxy;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.seasar.util.EMap;
import org.seasar.util.SeasarRuntimeException;

public final class JMXUtil {
    private static Map _nameMap = new EMap();
    private static Map _mbeanInfoMap = new EMap();

    private JMXUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectName getObjectName(String name) {
        ObjectName oname = (ObjectName)_nameMap.get(name);
        if (oname != null) {
            return oname;
        }
        Map map = _nameMap;
        synchronized (map) {
            oname = (ObjectName)_nameMap.get(name);
            if (oname == null) {
                try {
                    oname = new ObjectName(name);
                }
                catch (MalformedObjectNameException ex) {
                    throw new SeasarRuntimeException("ESSR0017", new Object[]{ex}, (Throwable)ex);
                }
                _nameMap.put(name, oname);
            }
        }
        return oname;
    }

    public static String getMBeanName(String name) {
        return "MBean:name=" + name;
    }

    public static String getJNDIName(String name) {
        return "mbean/" + name;
    }

    public static ObjectName getMBeanObjectName(String name) {
        return JMXUtil.getObjectName(JMXUtil.getMBeanName(name));
    }

    public static Class getMBeanInterface(Class mbeanClass) {
        Class mbeanInterface = null;
        for (Class concrete = mbeanClass; null != concrete; concrete = concrete.getSuperclass()) {
            mbeanInterface = JMXUtil.getMBeanInterface(concrete, concrete.getInterfaces());
            if (null == mbeanInterface) continue;
            return mbeanInterface;
        }
        return null;
    }

    private static Class getMBeanInterface(Class concrete, Class[] interfaces) {
        if (Proxy.isProxyClass(concrete)) {
            return JMXUtil.getMBeanInterfaceForProxy(concrete, interfaces);
        }
        return JMXUtil.getMBeanInterfaceForStandartMBean(concrete, interfaces);
    }

    private static Class getMBeanInterfaceForStandartMBean(Class concrete, Class[] interfaces) {
        String name = concrete.getName() + "MBean";
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].getName().equals(name)) continue;
            return interfaces[i];
        }
        return null;
    }

    private static Class getMBeanInterfaceForProxy(Class concrete, Class[] interfaces) {
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].getName().endsWith("MBean")) continue;
            return interfaces[i];
        }
        return null;
    }
}

