/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.system;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationListener;
import org.seasar.log.Logger;
import org.seasar.system.JMXUtil;
import org.seasar.system.Lifecycle;
import org.seasar.system.MBeanMetaData;
import org.seasar.system.NotificationListenerProxy;
import org.seasar.util.Reflector;
import org.seasar.util.SeasarException;

public final class JMXService
implements Lifecycle {
    private static Logger _logger = Logger.getLogger(class$org$seasar$system$JMXService == null ? (class$org$seasar$system$JMXService = JMXService.class$("org.seasar.system.JMXService")) : class$org$seasar$system$JMXService);
    private static Map _mbeans = new HashMap();
    private static Map _listenersMap = new HashMap();
    static /* synthetic */ Class class$org$seasar$system$JMXService;

    public static Object invoke(String name, String methodName, Object[] parameters, String[] signatures) throws Exception {
        Object mbean = JMXService.getMBean(name);
        MBeanMetaData mbeanMetaData = MBeanMetaData.getInstance(mbean.getClass());
        Method method = mbeanMetaData.getMethod(methodName, signatures);
        return Reflector.invoke(method, mbean, parameters);
    }

    public static void registerMBean(Object mbean, String name) throws SeasarException {
        MBeanMetaData.checkCompliance(mbean.getClass());
        if (_mbeans.put(name, mbean) != null) {
            throw new SeasarException("ESSR0335", new Object[]{name});
        }
    }

    public static void unregisterMBean(String name) {
        _mbeans.remove(name);
    }

    public static Object getMBean(String name) throws SeasarException {
        Object mbean = _mbeans.get(name);
        if (mbean == null) {
            throw new SeasarException("ESSR0001", new Object[]{name});
        }
        return mbean;
    }

    public static void addNotificationListener(String targetName, String listenerName) throws SeasarException {
        Object listener = JMXService.getMBean(listenerName);
        if (!(listener instanceof NotificationListener)) {
            throw new SeasarException("ESSR0336", new Object[]{listener.getClass().getName()});
        }
        JMXService.addNotificationListener(targetName, (NotificationListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addNotificationListener(String targetName, NotificationListener listener) throws SeasarException {
        Object target = JMXService.getMBean(targetName);
        if (!(target instanceof NotificationBroadcaster)) {
            throw new SeasarException("ESSR0337", new Object[]{target.getClass().getName()});
        }
        NotificationBroadcaster broadcaster = (NotificationBroadcaster)target;
        if (listener == null) {
            throw new SeasarException("ESSR0007", new Object[]{"listener"});
        }
        NotificationListenerProxy listenerProxy = new NotificationListenerProxy(JMXUtil.getObjectName(targetName), listener);
        broadcaster.addNotificationListener(listenerProxy, null, null);
        Map map = _listenersMap;
        synchronized (map) {
            HashMap<NotificationListener, NotificationListenerProxy> listeners = (HashMap<NotificationListener, NotificationListenerProxy>)_listenersMap.get(targetName);
            if (listeners == null) {
                listeners = new HashMap<NotificationListener, NotificationListenerProxy>();
                _listenersMap.put(targetName, listeners);
            }
            listeners.put(listener, listenerProxy);
        }
    }

    public static void removeNotificationListener(String targetName, String listenerName) throws SeasarException {
        Object listener = JMXService.getMBean(listenerName);
        if (!(listener instanceof NotificationListener)) {
            throw new SeasarException("ESSR0336", new Object[]{listener.getClass().getName()});
        }
        JMXService.removeNotificationListener(targetName, (NotificationListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeNotificationListener(String targetName, NotificationListener listener) throws SeasarException {
        Object target = JMXService.getMBean(targetName);
        if (!(target instanceof NotificationBroadcaster)) {
            throw new SeasarException("ESSR0337", new Object[]{target.getClass().getName()});
        }
        NotificationBroadcaster broadcaster = (NotificationBroadcaster)target;
        if (listener == null) {
            throw new SeasarException("ESSR0007", new Object[]{"listener"});
        }
        NotificationListener listenerProxy = null;
        Map map = _listenersMap;
        synchronized (map) {
            Map listeners = (Map)_listenersMap.get(targetName);
            listenerProxy = (NotificationListener)listeners.remove(listener);
        }
        if (listenerProxy == null) {
            throw new SeasarException("ESSR0001", new Object[]{"listenerProxy"});
        }
        try {
            broadcaster.removeNotificationListener(listenerProxy);
        }
        catch (ListenerNotFoundException ex) {
            throw SeasarException.convertSeasarException(ex);
        }
    }

    public static boolean isRegistered(String name) {
        return _mbeans.get(name) != null;
    }

    public void start() throws SeasarException {
    }

    public void stop() throws SeasarException {
        _mbeans.clear();
        _listenersMap.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

