/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.system;

import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.ServerSocket;
import java.net.Socket;
import org.seasar.log.Logger;
import org.seasar.system.Lifecycle;
import org.seasar.system.ThreadPool;
import org.seasar.util.NetUtil;
import org.seasar.util.SeasarException;
import org.seasar.util.ThreadUtil;

public abstract class AbstractSocketService
implements Lifecycle,
Runnable {
    private String _hostName = NetUtil.getHostAddress();
    private int _port = 0;
    private int _backlog = 50;
    private int _soTimeout = 0;
    private ServerSocket _serverSocket = null;
    private ThreadPool _threadPool = new ThreadPool();
    private boolean _started = false;

    public final String getHostName() {
        return this._hostName;
    }

    public final int getPort() {
        return this._port;
    }

    public final void setPort(int port) {
        this._port = port;
    }

    public final int getBacklog() {
        return this._backlog;
    }

    public final void setBacklog(int backlog) {
        this._backlog = backlog;
    }

    public final int getSoTimeout() {
        return this._soTimeout;
    }

    public final void setSoTimeout(int soTimeout) {
        this._soTimeout = soTimeout;
    }

    public final boolean isStarted() {
        return this._started;
    }

    public void start() throws SeasarException {
        this._threadPool.setMaxSize(this._backlog);
        this._threadPool.start();
        try {
            this._serverSocket = new ServerSocket(this._port, this._backlog);
            if (this._port == 0) {
                this._port = this._serverSocket.getLocalPort();
            }
            this.listen();
        }
        catch (IOException ex) {
            throw new SeasarException("ESSR0017", new Object[]{ex}, (Throwable)ex);
        }
        while (!this._started) {
            ThreadUtil.sleep(10L);
        }
    }

    public void stop() throws SeasarException {
        try {
            ServerSocket ss = this._serverSocket;
            this._serverSocket = null;
            ss.close();
            this._threadPool.stop();
            this._started = false;
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass()).log(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void run() {
        block14: {
            if (this._serverSocket == null) {
                return;
            }
            Socket socket = this.accept();
            if (socket == null) {
                return;
            }
            this.listen();
            this.handleSocket(socket);
            Object var4_2 = null;
            try {
                socket.close();
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass()).log(ex);
            }
            break block14;
            {
                catch (EOFException ignore) {
                    Object var4_3 = null;
                    try {
                        socket.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(this.getClass()).log(ex);
                    }
                    break block14;
                }
                catch (StreamCorruptedException ignore2) {
                    Object var4_4 = null;
                    try {
                        socket.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(this.getClass()).log(ex);
                    }
                    break block14;
                }
                catch (Throwable t) {
                    Logger.getLogger(this.getClass()).log(t);
                    Object var4_5 = null;
                    try {
                        socket.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(this.getClass()).log(ex);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    socket.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass()).log(ex);
                }
                throw throwable;
            }
        }
    }

    protected Socket accept() {
        try {
            this._started = true;
            Socket socket = this._serverSocket.accept();
            socket.setSoTimeout(this._soTimeout);
            return socket;
        }
        catch (IOException ex) {
            if (this._serverSocket != null) {
                Logger.getLogger(this.getClass()).log(ex);
            }
            return null;
        }
    }

    protected abstract void handleSocket(Socket var1) throws IOException;

    private void listen() {
        this._threadPool.request(this);
    }
}

