/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.seasar.sql.ConnectionImpl;
import org.seasar.sql.SQLXAResource;
import org.seasar.sql.XAConnectionEventListener;
import org.seasar.util.SeasarRuntimeException;

public final class XAConnectionImpl
implements XAConnection {
    private XAConnection _originalXAConnection;
    private Connection _physicalConnection;
    private ConnectionImpl _logicalConnection;
    private XAResource _xaResource;
    private List _listeners = new ArrayList();

    public XAConnectionImpl(XAConnection originalXAConnection) throws SQLException {
        if (originalXAConnection == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"originalXAConnection"});
        }
        this._originalXAConnection = originalXAConnection;
        this._physicalConnection = originalXAConnection.getConnection();
        this._xaResource = originalXAConnection.getXAResource();
        this._logicalConnection = new ConnectionImpl(this, this._physicalConnection);
    }

    public XAConnectionImpl(Connection physicalConnection) throws SQLException {
        if (physicalConnection == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"physicalConnection"});
        }
        this._physicalConnection = physicalConnection;
        this._xaResource = new SQLXAResource(this, physicalConnection);
        this._logicalConnection = new ConnectionImpl(this, physicalConnection);
    }

    public XAResource getXAResource() {
        return this._xaResource;
    }

    public Connection getConnection() throws SQLException {
        return this._logicalConnection;
    }

    public ConnectionImpl getLogicalConnection() throws SQLException {
        return this._logicalConnection;
    }

    public Connection getPhysicalConnection() throws SQLException {
        return this._physicalConnection;
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.notifyXAClose();
        this.closePhysicalConnection();
    }

    public void closePhysicalConnection() {
        if (this.isClosed()) {
            return;
        }
        try {
            this._physicalConnection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this._physicalConnection = null;
        this._logicalConnection = null;
        this._xaResource = null;
    }

    public boolean isClosed() {
        return this._physicalConnection == null;
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        this._listeners.add(listener);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        this._listeners.remove(listener);
    }

    public synchronized void notifyClose() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ConnectionEventListener listener = (ConnectionEventListener)this._listeners.get(i);
            listener.connectionClosed(new ConnectionEvent(this));
        }
    }

    public synchronized void notifyError(SQLException ex) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ConnectionEventListener listener = (ConnectionEventListener)this._listeners.get(i);
            listener.connectionErrorOccurred(new ConnectionEvent(this, ex));
        }
    }

    public synchronized void notifyXAClose() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ConnectionEventListener listener = (ConnectionEventListener)this._listeners.get(i);
            if (!(listener instanceof XAConnectionEventListener)) continue;
            ((XAConnectionEventListener)listener).xaConnectionClosed(new ConnectionEvent(this));
        }
    }

    synchronized void init() throws SQLException {
        if (this._originalXAConnection != null && this._physicalConnection.isClosed()) {
            Connection physicalConnection = this._originalXAConnection.getConnection();
            this._xaResource = new SQLXAResource(this, physicalConnection);
            this._logicalConnection = new ConnectionImpl(this, physicalConnection);
        }
    }
}

