/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.sql;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.seasar.sql.XAConnectionImpl;
import org.seasar.transaction.DefaultXAResource;
import org.seasar.util.SeasarRuntimeException;

public class SQLXAResource
extends DefaultXAResource {
    private XAConnectionImpl _xaConnection;
    private Connection _physicalConnection;

    public SQLXAResource(XAConnectionImpl xaConnection, Connection physicalConnection) {
        if (xaConnection == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"xaConnection"});
        }
        this._xaConnection = xaConnection;
        if (physicalConnection == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"physicalConnection"});
        }
        this._physicalConnection = physicalConnection;
    }

    protected void doBegin(Xid xid) throws XAException {
        try {
            if (this._physicalConnection.getAutoCommit()) {
                this._physicalConnection.setAutoCommit(false);
            }
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw new XAException(ex.toString());
        }
    }

    protected void doCommit(Xid xid, boolean onePhase) throws XAException {
        try {
            this._physicalConnection.commit();
            this._physicalConnection.setAutoCommit(true);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw new XAException(ex.toString());
        }
    }

    protected int doPrepare(Xid xid) throws XAException {
        try {
            if (this._physicalConnection.isClosed()) {
                return 3;
            }
            return 0;
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw new XAException(ex.toString());
        }
    }

    protected void doRollback(Xid xid) throws XAException {
        try {
            this._physicalConnection.rollback();
            this._physicalConnection.setAutoCommit(true);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw new XAException(ex.toString());
        }
    }
}

