/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.sql;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.seasar.sql.XAConnectionImpl;
import org.seasar.util.Reflector;
import org.seasar.util.SeasarRuntimeException;

public class ConnectionPoolMetaData
implements Serializable {
    static final long serialVersionUID = 3767222791192220772L;
    private static final int DEFAULT_TIMEOUT = 600;
    private final String _dataSourceName;
    private final String _jndiName;
    private final String _xaDataSourceClassName;
    private final int _timeout;
    private final int _poolSize;
    private final int _hashCode;
    private Properties _properties;
    private transient XADataSource _xaDataSource;

    public ConnectionPoolMetaData(String dataSourceName, String jndiName, String xaDataSourceClassName, int timeout, int poolSize) {
        this(dataSourceName, jndiName, xaDataSourceClassName, timeout, poolSize, null);
    }

    public ConnectionPoolMetaData(String dataSourceName, String jndiName, String xaDataSourceClassName, int timeout, int poolSize, Properties properties) {
        if (dataSourceName == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"dataSourceName"});
        }
        this._dataSourceName = dataSourceName;
        this._hashCode = dataSourceName.hashCode();
        if (jndiName == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"jndiName"});
        }
        this._jndiName = jndiName;
        if (xaDataSourceClassName == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"xaDataSourceClassName"});
        }
        this._xaDataSourceClassName = xaDataSourceClassName;
        this._timeout = timeout > 0 ? timeout : 600;
        this._poolSize = poolSize > 0 ? poolSize : 1;
        this._properties = properties;
    }

    public String getDataSourceName() {
        return this._dataSourceName;
    }

    public String getJNDIName() {
        return this._jndiName;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public int getPoolSize() {
        return this._poolSize;
    }

    public void setProperties(Properties properties) {
        this._properties = properties;
    }

    public XAConnectionImpl getXAConnection() throws SQLException {
        XADataSource xaDs = this.getXADataSource();
        XAConnection xaCon = xaDs.getXAConnection();
        if (xaCon instanceof XAConnectionImpl) {
            return (XAConnectionImpl)xaCon;
        }
        return new XAConnectionImpl(xaCon);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ConnectionPoolMetaData)) {
            return false;
        }
        return this._dataSourceName.equals(((ConnectionPoolMetaData)o)._dataSourceName);
    }

    public int hashCode() {
        return this._hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XADataSource getXADataSource() throws SQLException {
        if (this._xaDataSource != null) {
            return this._xaDataSource;
        }
        ConnectionPoolMetaData connectionPoolMetaData = this;
        synchronized (connectionPoolMetaData) {
            if (this._xaDataSource == null) {
                this._xaDataSource = this.newXADataSource();
            }
        }
        return this._xaDataSource;
    }

    private XADataSource newXADataSource() {
        if (this._properties == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"properties"});
        }
        XADataSource ds = (XADataSource)Reflector.newInstance(this._xaDataSourceClassName);
        Reflector.setProperties((Object)ds, this._properties);
        return ds;
    }
}

