/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.sql;

import org.seasar.sql.ConnectionPool;
import org.seasar.sql.ConnectionPoolMetaData;
import org.seasar.util.Assertion;
import org.seasar.util.EMap;

public final class ConnectionPoolManager {
    private static ConnectionPoolManager _instance = new ConnectionPoolManager();
    private EMap _connectionPools = new EMap();

    private ConnectionPoolManager() {
        Thread t = new Thread(){

            public void run() {
                ConnectionPoolManager.this.close();
            }
        };
        try {
            Runtime.getRuntime().addShutdownHook(t);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static ConnectionPoolManager getInstance() {
        return _instance;
    }

    public ConnectionPool getConnectionPool(String dataSourceName) {
        ConnectionPool pool = (ConnectionPool)this._connectionPools.get(dataSourceName);
        Assertion.assertFound(dataSourceName, pool);
        return pool;
    }

    public boolean hasConnectionPoolMetaData(String dataSourceName) {
        Assertion.assertNotNull("dataSourceName", dataSourceName);
        return this._connectionPools.containsKey(dataSourceName);
    }

    public synchronized void registerConnectionPoolMetaData(ConnectionPoolMetaData connectionPoolMetaData) {
        Assertion.assertNotNull("connectionPoolMetaData", connectionPoolMetaData);
        if (this._connectionPools.containsKey(connectionPoolMetaData.getDataSourceName())) {
            return;
        }
        this._connectionPools.put(connectionPoolMetaData.getDataSourceName(), new ConnectionPool(connectionPoolMetaData));
    }

    public synchronized void close() {
        for (int i = 0; i < this._connectionPools.size(); ++i) {
            ConnectionPool cp = (ConnectionPool)this._connectionPools.get(i);
            cp.close();
        }
        this._connectionPools.clear();
    }
}

