/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.sql;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.ConnectionEvent;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.seasar.sql.ConnectionPoolMetaData;
import org.seasar.sql.XAConnectionEventListener;
import org.seasar.sql.XAConnectionImpl;
import org.seasar.timer.TimeoutManager;
import org.seasar.timer.TimeoutTarget;
import org.seasar.timer.TimeoutTask;
import org.seasar.transaction.TransactionManagerImpl;
import org.seasar.transaction.XAResourceManager;
import org.seasar.util.ELinkedList;
import org.seasar.util.SeasarRuntimeException;

public final class ConnectionPool
implements XAConnectionEventListener,
Synchronization {
    private final ConnectionPoolMetaData _connectionPoolMetaData;
    private final Map _activePool = new HashMap();
    private final Map _txPool = new HashMap();
    private final ELinkedList _freePool = new ELinkedList();

    public ConnectionPool(ConnectionPoolMetaData connectionPoolMetaData) {
        if (connectionPoolMetaData == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"connectionPoolMetafData"});
        }
        this._connectionPoolMetaData = connectionPoolMetaData;
    }

    public final String getDataSourceName() {
        return this._connectionPoolMetaData.getDataSourceName();
    }

    public final synchronized XAConnectionImpl requestXAConnection() throws SQLException {
        while (this._activePool.size() >= this._connectionPoolMetaData.getPoolSize()) {
            try {
                this.wait();
            }
            catch (InterruptedException ign) {}
        }
        XAConnectionImpl xaCon = this.requestFreeXAConnection();
        if (xaCon == null) {
            xaCon = this._connectionPoolMetaData.getXAConnection();
            xaCon.addConnectionEventListener(this);
        }
        try {
            XAResourceManager.getInstance().addXAResource(xaCon.getXAResource());
            this._activePool.put(xaCon, null);
            Transaction tx = TransactionManagerImpl.getInstance().getTransaction();
            if (tx != null) {
                tx.registerSynchronization((Synchronization)this);
            }
        }
        catch (SystemException se) {
            throw new SQLException(se.toString());
        }
        catch (RollbackException re) {
            throw new SQLException(re.toString());
        }
        return xaCon;
    }

    public final synchronized void returnXAConnection(XAConnectionImpl xaConnection) {
        XAResourceManager.getInstance().removeXAResource(xaConnection.getXAResource());
        this._activePool.remove(xaConnection);
        Transaction tx = TransactionManagerImpl.getInstance().getTransaction();
        if (tx != null) {
            this._txPool.put(tx, xaConnection);
        } else {
            this.returnFreePool(xaConnection);
        }
        this.notify();
    }

    public final synchronized void releaseXAConnection(XAConnectionImpl xaConnection) {
        XAResourceManager.getInstance().removeXAResource(xaConnection.getXAResource());
        this._activePool.remove(xaConnection);
        xaConnection.removeConnectionEventListener(this);
        this.closeXAConnection(xaConnection);
        this.notify();
    }

    public final int getPoolSize() {
        return this._freePool.size();
    }

    public final int getActviePoolSize() {
        return this._activePool.size();
    }

    public final void connectionClosed(ConnectionEvent event) {
        this.returnXAConnection((XAConnectionImpl)event.getSource());
    }

    public final void connectionErrorOccurred(ConnectionEvent event) {
        this.releaseXAConnection((XAConnectionImpl)event.getSource());
    }

    public final void xaConnectionClosed(ConnectionEvent event) {
        this.releaseXAConnection((XAConnectionImpl)event.getSource());
    }

    public final void afterCompletion(int status) {
        switch (status) {
            case 3: 
            case 4: {
                this.returnFreePoolForTx();
            }
        }
    }

    public final void beforeCompletion() {
    }

    public final synchronized void close() {
        XAConnectionImpl xaCon;
        for (ELinkedList.Entry e = this._freePool.getFirstEntry(); e != null; e = e.getNext()) {
            FreeItem item = (FreeItem)e.getElement();
            this.closeXAConnection(item._xaConnection);
            item.destroy();
        }
        this._freePool.clear();
        Iterator<Object> i = this._txPool.values().iterator();
        while (i.hasNext()) {
            xaCon = (XAConnectionImpl)i.next();
            this.closeXAConnection(xaCon);
        }
        this._txPool.clear();
        i = this._activePool.keySet().iterator();
        while (i.hasNext()) {
            xaCon = (XAConnectionImpl)i.next();
            XAResourceManager.getInstance().removeXAResource(xaCon.getXAResource());
            this.closeXAConnection(xaCon);
        }
        this._activePool.clear();
    }

    private synchronized XAConnectionImpl requestFreeXAConnection() throws SQLException {
        XAConnectionImpl xaCon = this.requestXAConnectionFromTxPool();
        if (xaCon == null) {
            xaCon = this.requestXAConnectionFromFreePool();
        }
        if (xaCon != null) {
            xaCon.init();
            return xaCon;
        }
        return null;
    }

    private synchronized XAConnectionImpl requestXAConnectionFromTxPool() throws SQLException {
        Transaction tx = TransactionManagerImpl.getInstance().getTransaction();
        if (tx != null) {
            return (XAConnectionImpl)this._txPool.remove(tx);
        }
        return null;
    }

    private synchronized XAConnectionImpl requestXAConnectionFromFreePool() throws SQLException {
        if (this._freePool.isEmpty()) {
            return null;
        }
        FreeItem item = (FreeItem)this._freePool.removeLast();
        XAConnectionImpl xaCon = item._xaConnection;
        item.destroy();
        return xaCon;
    }

    private synchronized void returnFreePoolForTx() {
        try {
            XAConnectionImpl xaCon = this.requestXAConnectionFromTxPool();
            if (xaCon != null) {
                this.returnFreePool(xaCon);
            }
        }
        catch (SQLException ex) {
            throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
        }
    }

    private synchronized void returnFreePool(XAConnectionImpl xaConnection) {
        this._freePool.addLast(new FreeItem(xaConnection));
        this.notifyAll();
    }

    private void closeXAConnection(XAConnectionImpl xaConnection) {
        xaConnection.closePhysicalConnection();
    }

    private class FreeItem
    implements TimeoutTarget {
        private XAConnectionImpl _xaConnection;
        private TimeoutTask _timeoutTask;

        FreeItem(XAConnectionImpl xaConnection) {
            this._xaConnection = xaConnection;
            this._timeoutTask = TimeoutManager.getInstance().addTimeoutTarget(this, ConnectionPool.this._connectionPoolMetaData.getTimeout(), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expired() {
            ELinkedList eLinkedList = ConnectionPool.this._freePool;
            synchronized (eLinkedList) {
                ConnectionPool.this._freePool.remove(this);
            }
            ConnectionPool.this.closeXAConnection(this._xaConnection);
            this.destroy();
        }

        void destroy() {
            this._xaConnection = null;
            this._timeoutTask.cancel();
        }
    }
}

