/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.sql;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.seasar.sql.XAConnectionImpl;
import org.seasar.util.SeasarRuntimeException;

public final class ConnectionImpl
implements Connection {
    private XAConnectionImpl _xaConnection;
    private Connection _physicalConnection;

    public ConnectionImpl(XAConnectionImpl xaConnection, Connection physicalConnection) {
        if (xaConnection == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"xaConnection"});
        }
        this._xaConnection = xaConnection;
        if (physicalConnection == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"physicalConnection"});
        }
        this._physicalConnection = physicalConnection;
    }

    public Connection getPhysicalConnection() {
        return this._physicalConnection;
    }

    public Statement createStatement() throws SQLException {
        try {
            return this._physicalConnection.createStatement();
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            return this._physicalConnection.prepareStatement(sql);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            return this._physicalConnection.prepareCall(sql);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        try {
            return this._physicalConnection.nativeSQL(sql);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public boolean isClosed() throws SQLException {
        if (this._physicalConnection == null) {
            return true;
        }
        try {
            return this._physicalConnection.isClosed();
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this._physicalConnection.getMetaData();
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this._physicalConnection.setReadOnly(readOnly);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            return this._physicalConnection.isReadOnly();
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        try {
            this._physicalConnection.setCatalog(catalog);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public String getCatalog() throws SQLException {
        try {
            return this._physicalConnection.getCatalog();
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public void close() throws SQLException {
        if (this._physicalConnection == null) {
            return;
        }
        this._xaConnection.notifyClose();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        try {
            this._physicalConnection.setTransactionIsolation(level);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            return this._physicalConnection.getTransactionIsolation();
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this._physicalConnection.getWarnings();
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this._physicalConnection.clearWarnings();
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public void commit() throws SQLException {
        try {
            this._physicalConnection.commit();
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public void rollback() throws SQLException {
        try {
            this._physicalConnection.rollback();
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this._physicalConnection.setAutoCommit(autoCommit);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            return this._physicalConnection.getAutoCommit();
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this._physicalConnection.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            return this._physicalConnection.getTypeMap();
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        try {
            this._physicalConnection.setTypeMap(map);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this._physicalConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this._physicalConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public void setHoldability(int holdability) throws SQLException {
        try {
            this._physicalConnection.setHoldability(holdability);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public int getHoldability() throws SQLException {
        try {
            return this._physicalConnection.getHoldability();
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        try {
            return this._physicalConnection.setSavepoint();
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            return this._physicalConnection.setSavepoint(name);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this._physicalConnection.rollback(savepoint);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this._physicalConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return this._physicalConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return this._physicalConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return this._physicalConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this._physicalConnection.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this._physicalConnection.prepareStatement(sql, columnIndexes);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            return this._physicalConnection.prepareStatement(sql, columnNames);
        }
        catch (SQLException ex) {
            this._xaConnection.notifyError(ex);
            throw ex;
        }
    }
}

