/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna.amf;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import org.seasar.log.Logger;
import org.seasar.nazuna.amf.AMFBody;
import org.seasar.nazuna.amf.AMFMessage;
import org.seasar.util.EMap;
import org.seasar.util.PropertyDesc;
import org.seasar.util.Reflector;
import org.seasar.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AMFWriter {
    private static Logger _logger = Logger.getLogger(class$org$seasar$nazuna$amf$AMFWriter == null ? (class$org$seasar$nazuna$amf$AMFWriter = AMFWriter.class$("org.seasar.nazuna.amf.AMFWriter")) : class$org$seasar$nazuna$amf$AMFWriter);
    private DataOutputStream _outputStream;
    private AMFMessage _message;
    private ArrayList _sharedObjects;
    static /* synthetic */ Class class$org$seasar$nazuna$amf$AMFWriter;

    public AMFWriter(DataOutputStream outputStream, AMFMessage message) {
        this._outputStream = outputStream;
        this._message = message;
    }

    public final void write() throws IOException {
        this._outputStream.writeShort(0);
        this._outputStream.writeShort(0);
        this.writeBodies();
    }

    public final void writeBodies() throws IOException {
        this._outputStream.writeShort(this._message.getBodyCount());
        for (int i = 0; i < this._message.getBodyCount(); ++i) {
            this._sharedObjects = new ArrayList();
            this.writeBody(this._message.getBody(i));
        }
    }

    public final void writeBody(AMFBody body) throws IOException {
        this._outputStream.writeUTF(body.getTarget());
        this._outputStream.writeUTF(body.getResponse());
        this._outputStream.writeInt(-1);
        this.writeData(body.getValue());
    }

    protected void writeData(Object value) throws IOException {
        if (value == null) {
            this._outputStream.writeByte(5);
        } else if (value instanceof String) {
            this.writeString((String)value);
        } else if (value instanceof BigDecimal) {
            this.writeString(value.toString());
        } else if (value instanceof Number) {
            this.writeNumber((Number)value);
        } else if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Date) {
            this.writeDate((Date)value);
        } else if (value instanceof Object[]) {
            this.writeArray((Object[])value);
        } else if (value instanceof Iterator) {
            this.writeIterator((Iterator)value);
        } else if (value instanceof Collection) {
            this.writeCollection((Collection)value);
        } else if (value instanceof Map) {
            this.writeMap((Map)value);
        } else if (value instanceof Document) {
            this.writeXML((Document)value);
        } else {
            this.writeCustomClass(value);
        }
    }

    public final void writeNumber(Number value) throws IOException {
        this._outputStream.writeByte(0);
        this._outputStream.writeDouble(value.doubleValue());
    }

    public final void writeString(String value) throws IOException {
        this._outputStream.writeByte(2);
        this._outputStream.writeUTF(value);
    }

    public final void writeBoolean(Boolean value) throws IOException {
        this._outputStream.writeByte(1);
        this._outputStream.writeBoolean(value);
    }

    public final void writeFlashedSharedObject(int index) throws IOException {
        _logger.debug("writeFlashedSharedObject:index=" + index);
        this._outputStream.writeByte(7);
        this._outputStream.writeShort(index);
    }

    public final void writeDate(Date value) throws IOException {
        this._outputStream.writeByte(11);
        this._outputStream.writeDouble(value.getTime());
        int offset = TimeZone.getDefault().getRawOffset();
        this._outputStream.writeShort(offset / 3600000);
    }

    public final void writeCustomClass(Object object) throws IOException {
        int index = this.getSharedIndex(object);
        if (index >= 0) {
            this.writeFlashedSharedObject(index);
            return;
        }
        this.addSharedObject(object);
        int id = System.identityHashCode(object);
        String type = object.getClass().getName();
        _logger.debug("writeCustomClass:" + type + ",id=" + id);
        this._outputStream.writeByte(16);
        this._outputStream.writeUTF(type);
        EMap map = Reflector.getPropertyDescMap(object.getClass());
        for (int i = 0; i < map.size(); ++i) {
            PropertyDesc propertyDesc = (PropertyDesc)map.get(i);
            if (propertyDesc.getReadMethod() != null) {
                Object value = propertyDesc.getValue(object);
                _logger.debug("id=" + id + ",propetyName=" + propertyDesc.getPropertyName() + ",value=" + value);
                this._outputStream.writeUTF(propertyDesc.getPropertyName());
                this.writeData(value);
                continue;
            }
            _logger.debug("id=" + id + "propetyName=" + propertyDesc.getPropertyName() + " readMethod not found");
        }
        this._outputStream.writeShort(0);
        this._outputStream.writeByte(9);
    }

    public final void writeArray(Object[] value) throws IOException {
        int index = this.getSharedIndex(value);
        if (index >= 0) {
            this.writeFlashedSharedObject(index);
            return;
        }
        this.addSharedObject(value);
        _logger.debug("writeArray:size=" + value.length);
        this._outputStream.writeByte(10);
        this._outputStream.writeInt(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.writeData(value[i]);
        }
    }

    public final void writeIterator(Iterator value) throws IOException {
        ArrayList list = new ArrayList();
        while (value.hasNext()) {
            list.add(value.next());
        }
        this.writeArray(list.toArray(new Object[list.size()]));
    }

    public final void writeCollection(Collection value) throws IOException {
        ArrayList list = new ArrayList();
        list.addAll(value);
        this.writeArray(list.toArray(new Object[list.size()]));
    }

    public final void writeMap(Map value) throws IOException {
        int index = this.getSharedIndex(value);
        if (index >= 0) {
            this.writeFlashedSharedObject(index);
            return;
        }
        int id = System.identityHashCode(value);
        this.addSharedObject(value);
        _logger.debug("writeMap:id=" + id);
        this._outputStream.writeByte(3);
        Iterator i = value.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String propertyName = String.valueOf(e.getKey());
            _logger.debug("id=" + id + ",propetyName=" + propertyName + ",value=" + e.getValue());
            this._outputStream.writeUTF(propertyName);
            this.writeData(e.getValue());
        }
        this._outputStream.writeShort(0);
        this._outputStream.writeByte(9);
    }

    public final void writeXML(Document document) throws IOException {
        this._outputStream.writeByte(15);
        Element element = document.getDocumentElement();
        String xmlData = XMLUtil.toString(element);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(xmlData.getBytes());
        this._outputStream.writeInt(baos.size());
        baos.writeTo(this._outputStream);
    }

    private void addSharedObject(Object o) {
        _logger.debug("addSharedObject:index=" + this._sharedObjects.size() + ",value=" + o);
        this._sharedObjects.add(o);
    }

    private final int getSharedIndex(Object o) {
        for (int i = 0; i < this._sharedObjects.size(); ++i) {
            if (o != this._sharedObjects.get(i)) continue;
            return i;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

