/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna.amf;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.seasar.log.Logger;
import org.seasar.nazuna.NazunaUtil;
import org.seasar.nazuna.amf.AMFMessage;
import org.seasar.util.EMap;
import org.seasar.util.PropertyDesc;
import org.seasar.util.Reflector;
import org.seasar.util.Struct;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class AMFReader {
    private static Logger _logger = Logger.getLogger(class$org$seasar$nazuna$amf$AMFReader == null ? (class$org$seasar$nazuna$amf$AMFReader = AMFReader.class$("org.seasar.nazuna.amf.AMFReader")) : class$org$seasar$nazuna$amf$AMFReader);
    private DataInputStream _inputStream;
    private AMFMessage _message = new AMFMessage();
    private ArrayList _sharedObjects;
    static /* synthetic */ Class class$org$seasar$nazuna$amf$AMFReader;

    public AMFReader(DataInputStream inputStream) {
        this._inputStream = inputStream;
    }

    public final AMFMessage read() throws IOException {
        this.skipHeaders();
        this.readBodies();
        return this._message;
    }

    public final void skipHeaders() throws IOException {
        this._inputStream.readUnsignedShort();
        int headerCount = this._inputStream.readUnsignedShort();
        for (int i = 0; i < headerCount; ++i) {
            this._inputStream.readUTF();
            this.readBoolean();
            this._inputStream.readInt();
            this.readData();
        }
    }

    public final void readBodies() throws IOException {
        int bodyCount = this._inputStream.readUnsignedShort();
        for (int i = 0; i < bodyCount; ++i) {
            this._sharedObjects = new ArrayList();
            String target = this._inputStream.readUTF();
            String response = this._inputStream.readUTF();
            int length = this._inputStream.readInt();
            Object data = this.readData();
            this._message.addBody(target, response, data);
        }
    }

    public final Object readData() throws IOException {
        byte dataType = this._inputStream.readByte();
        return this.readData(dataType);
    }

    public final Object readData(byte dataType) throws IOException {
        switch (dataType) {
            case 0: {
                double d = this._inputStream.readDouble();
                _logger.debug("readNumber:" + d);
                return new Double(d);
            }
            case 1: {
                Boolean b = this.readBoolean();
                _logger.debug("readBoolean:" + b);
                return b;
            }
            case 2: {
                String s = this._inputStream.readUTF();
                _logger.debug("readString:" + s);
                return s;
            }
            case 3: {
                return this.readMap();
            }
            case 5: {
                _logger.debug("readNull:");
                return null;
            }
            case 7: {
                return this.readFlashedSharedObject();
            }
            case 8: {
                _logger.debug("readArraySharedObject:");
                return null;
            }
            case 10: {
                return this.readArray();
            }
            case 11: {
                Date date = this.readDate();
                _logger.debug("readDate:" + date);
                return date;
            }
            case 13: {
                _logger.debug("readASObject:");
                return null;
            }
            case 15: {
                _logger.debug("readXML:");
                return this.readXML();
            }
            case 16: {
                return this.readCustomClass();
            }
        }
        return null;
    }

    public final Object readCustomClass() throws IOException {
        String type = this._inputStream.readUTF();
        _logger.debug("readCustomClass:" + type);
        Class clazz = Reflector.getClass(type);
        Object target = Reflector.newInstance(clazz);
        this.addSharedObject(target);
        EMap propertyDescMap = Reflector.getPropertyDescMap(clazz);
        String propertyName = this._inputStream.readUTF();
        byte dataType = this._inputStream.readByte();
        while (dataType != 9) {
            Object value = this.readData(dataType);
            _logger.debug("propetyName=" + propertyName + ",value=" + value);
            PropertyDesc propertyDesc = (PropertyDesc)propertyDescMap.get(propertyName);
            value = NazunaUtil.adjustValue(value, propertyDesc.getPropertyType());
            if (propertyDesc.getWriteMethod() != null) {
                propertyDesc.setValue(target, value);
            }
            propertyName = this._inputStream.readUTF();
            dataType = this._inputStream.readByte();
        }
        return target;
    }

    public final Map readMap() throws IOException {
        _logger.debug("readMap:");
        Struct map = new Struct();
        this.addSharedObject(map);
        String key = this._inputStream.readUTF();
        byte dataType = this._inputStream.readByte();
        while (dataType != 9) {
            Object value = this.readData(dataType);
            _logger.debug("key=" + key + ",value=" + value);
            map.put(key, value);
            key = this._inputStream.readUTF();
            dataType = this._inputStream.readByte();
        }
        return map;
    }

    public final ArrayList readArray() throws IOException {
        ArrayList<Object> array = new ArrayList<Object>();
        this.addSharedObject(array);
        int length = this._inputStream.readInt();
        _logger.debug("readArray:size=" + length);
        for (int i = 0; i < length; ++i) {
            Object item = this.readData();
            _logger.debug("item(" + i + ")=" + item);
            array.add(item);
        }
        return array;
    }

    public final Boolean readBoolean() throws IOException {
        byte value = this._inputStream.readByte();
        if (value == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public final Date readDate() throws IOException {
        double ms = this._inputStream.readDouble();
        int offset = this._inputStream.readUnsignedShort() * 3600000;
        int defaultOffset = TimeZone.getDefault().getRawOffset();
        Date date = new Date((long)(ms += (double)defaultOffset - (double)offset));
        return date;
    }

    public final Document readXML() throws IOException {
        this._inputStream.skip(4L);
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this._inputStream);
        }
        catch (SAXException ex) {
            throw this.convertIOException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw this.convertIOException(ex);
        }
    }

    public final Object readFlashedSharedObject() throws IOException {
        int index = this._inputStream.readUnsignedShort();
        Object target = this._sharedObjects.get(index);
        _logger.debug("readFlashedSharedObject:index=" + index + ",value=" + target);
        return target;
    }

    private void addSharedObject(Object o) {
        _logger.debug("addSharedObject:index=" + this._sharedObjects.size() + ",value=" + o);
        this._sharedObjects.add(o);
    }

    private IOException convertIOException(Exception ex) {
        IOException ioe = new IOException(ex.getMessage());
        ioe.initCause(ex);
        return ioe;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

