/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna.amf;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.log.Logger;
import org.seasar.nazuna.amf.AMFBody;
import org.seasar.nazuna.amf.AMFError;
import org.seasar.nazuna.amf.AMFMessage;
import org.seasar.nazuna.amf.AMFReader;
import org.seasar.nazuna.amf.AMFWriter;
import org.seasar.util.ThrowableUtil;

public final class AMFGateway
extends HttpServlet {
    static /* synthetic */ Class class$org$seasar$nazuna$amf$AMFGateway;

    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.getWriter().write("AMFGateway is running.");
    }

    public final void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            AMFMessage requestMessage = this.readMessage(request);
            AMFMessage responseMessage = this.processMessage(request, requestMessage);
            this.writeMessage(response, responseMessage);
        }
        catch (Throwable t) {
            Throwable cause = ThrowableUtil.getCause(t);
            Logger.getLogger(class$org$seasar$nazuna$amf$AMFGateway == null ? (class$org$seasar$nazuna$amf$AMFGateway = AMFGateway.class$("org.seasar.nazuna.amf.AMFGateway")) : class$org$seasar$nazuna$amf$AMFGateway).log(cause);
            throw new ServletException(cause);
        }
    }

    public final AMFMessage readMessage(HttpServletRequest request) throws IOException, ServletException {
        Object is = request.getInputStream();
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream((InputStream)is);
        }
        DataInputStream inputStream = new DataInputStream((InputStream)is);
        AMFReader reader = new AMFReader(inputStream);
        return reader.read();
    }

    public final AMFMessage processMessage(HttpServletRequest request, AMFMessage requestMessage) throws IOException {
        AMFMessage responseMessage = new AMFMessage();
        for (int i = 0; i < requestMessage.getBodyCount(); ++i) {
            AMFBody requestBody = requestMessage.getBody(i);
            AMFBody responseBody = this.processBody(request, requestBody);
            responseMessage.addBody(responseBody);
        }
        return responseMessage;
    }

    public final AMFBody processBody(HttpServletRequest request, AMFBody requestBody) {
        try {
            Object result = requestBody.invoke(request);
            String target = requestBody.getResponse() + "/onResult";
            return new AMFBody(target, "null", result);
        }
        catch (Throwable t) {
            String target = requestBody.getResponse() + "/onStatus";
            return new AMFBody(target, "null", new AMFError(t));
        }
    }

    public final void writeMessage(HttpServletResponse response, AMFMessage responseMessage) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        AMFWriter writer = new AMFWriter(outputStream, responseMessage);
        writer.write();
        response.setContentType("application/x-amf");
        response.setContentLength(baos.size());
        baos.writeTo((OutputStream)response.getOutputStream());
        outputStream.flush();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

