/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna.amf;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.seasar.nazuna.Nazuna;
import org.seasar.util.ArrayUtil;
import org.seasar.util.SeasarException;

public final class AMFBody {
    private String _target;
    private String _serviceName;
    private String _serviceMethodName;
    private String _response;
    private Object _value;

    public AMFBody(String target, String response, Object value) {
        this._target = target;
        this._response = response;
        this._value = value;
        int dotIndex = target.lastIndexOf(46);
        if (dotIndex > 0) {
            this._serviceName = target.substring(0, dotIndex);
            this._serviceMethodName = target.substring(dotIndex + 1);
        }
    }

    public final String getTarget() {
        return this._target;
    }

    public final String getServiceName() {
        return this._serviceName;
    }

    public final String getServiceMethodName() {
        return this._serviceMethodName;
    }

    public final String getResponse() {
        return this._response;
    }

    public final Object getValue() {
        return this._value;
    }

    public final Object invoke(HttpServletRequest request) throws SeasarException {
        Object[] args = this.convertArgs();
        if ("execute".equalsIgnoreCase(this._serviceMethodName)) {
            return Nazuna.execute(this._serviceName, args);
        }
        if ("executeRSQuery".equalsIgnoreCase(this._serviceMethodName)) {
            return Nazuna.executeRSQuery(this._serviceName, args);
        }
        if ("executeQuery".equalsIgnoreCase(this._serviceMethodName)) {
            return Nazuna.executeQuery(this._serviceName, args);
        }
        if ("executeUpdate".equalsIgnoreCase(this._serviceMethodName)) {
            return new Integer(Nazuna.executeUpdate(this._serviceName, args));
        }
        if ("executeSingleQuery".equalsIgnoreCase(this._serviceMethodName)) {
            return Nazuna.executeSingleQuery(this._serviceName, args);
        }
        if ("executeRulet".equalsIgnoreCase(this._serviceMethodName)) {
            return Nazuna.executeRulet(this._serviceName, args);
        }
        throw new SeasarException("ESSR0001", this._serviceMethodName);
    }

    public final Object[] convertArgs() {
        if (this._value != null && this._value instanceof List) {
            return ((List)this._value).toArray();
        }
        return ArrayUtil.EMPTY_OBJECTS;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("target=");
        buf.append(this._target);
        buf.append(",response=");
        buf.append(this._response);
        buf.append(",value=");
        buf.append(this._value);
        return buf.toString();
    }
}

