/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import org.seasar.nazuna.NazunaUtil;
import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public class VarType {
    public static final OutType OUT_TYPE = new OutType();
    private String _name;
    private Class _varClass;
    private Object _defaultValue;

    public VarType(String name, Class varClass) {
        Assertion.assertNotNull("name", name);
        Assertion.assertTrue(NazunaUtil.isVarArgStartChar(name.charAt(0)), "ESSR0037", null);
        Assertion.assertNotNull("varClass", varClass);
        this._name = name;
        this._varClass = varClass;
    }

    public final String getName() {
        return this._name;
    }

    public final Class getVarClass() {
        return this._varClass;
    }

    public Object getDefaultValue() {
        return this._defaultValue;
    }

    public final void setDefaultValue(Object defaultValue) throws SeasarException {
        this.validate(defaultValue);
        this._defaultValue = defaultValue;
    }

    public final void validate(Object value) throws SeasarException {
        if (value != null && !this._varClass.isInstance(value)) {
            throw new SeasarException("ESSR0002", new Object[]{this._name, this._varClass.getName(), value.getClass().getName()});
        }
    }

    public static class OutType
    extends VarType {
        OutType() {
            super("out", System.out.getClass());
        }

        public Object getInitValue() {
            return System.out;
        }
    }
}

