/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import org.seasar.nazuna.VarType;
import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public class Var {
    public static final Var OUT = new Out();
    protected VarType _varType;
    protected Object _value;

    public Var(VarType varType) throws SeasarException {
        Assertion.assertNotNull("varType", varType);
        this._varType = varType;
        this._value = varType.getDefaultValue();
    }

    protected Var() {
    }

    public VarType getVarType() {
        return this._varType;
    }

    public String getName() {
        return this._varType.getName();
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) throws SeasarException {
        this._varType.validate(value);
        this._value = value;
    }

    private static class Out
    extends Var {
        Out() {
            this._varType = VarType.OUT_TYPE;
            this._value = VarType.OUT_TYPE.getInitValue();
        }

        public void setValue(Object value) throws SeasarException {
            throw new SeasarException("ESSR0010", new Object[]{"setValue"});
        }
    }
}

