/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.seasar.util.ArrayUtil;
import org.seasar.util.Assertion;
import org.seasar.util.SMap;
import org.seasar.util.SeasarException;

public abstract class ValueType {
    public static final String STRING_NAME = "String";
    public static final String INTEGER_NAME = "Integer";
    public static final String LONG_NAME = "Long";
    public static final String DOUBLE_NAME = "Double";
    public static final String BIGDECIMAL_NAME = "BigDecimal";
    public static final String TIMESTAMP_NAME = "Timestamp";
    public static final String BINARY_NAME = "Binary";
    public static final ValueType STRING = new StringType("String");
    public static final ValueType INTEGER = new IntegerType("Integer");
    public static final ValueType LONG = new LongType("Long");
    public static final ValueType DOUBLE = new DoubleType("Double");
    public static final ValueType BIGDECIMAL = new BigDecimalType("BigDecimal");
    public static final ValueType TIMESTAMP = new TimestampType("Timestamp");
    public static final ValueType BINARY = new BinaryType("Binary");
    private static Map _typesByName = new SMap();
    private static Map _typesByClass = new SMap();
    private String _name;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Timestamp;

    protected ValueType(String name) {
        this._name = name;
    }

    public static ValueType getType(String name) {
        ValueType valueType = (ValueType)_typesByName.get(name);
        Assertion.assertFound("name", valueType);
        return valueType;
    }

    public static ValueType getType(Class clazz) {
        ValueType valueType = (ValueType)_typesByClass.get(clazz);
        Assertion.assertFound(clazz.getName(), valueType);
        return valueType;
    }

    public static ValueType getType(int type) {
        switch (type) {
            case -6: 
            case 4: 
            case 5: {
                return INTEGER;
            }
            case -5: {
                return LONG;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return DOUBLE;
            }
            case 91: 
            case 92: 
            case 93: {
                return TIMESTAMP;
            }
            case -3: 
            case -2: {
                return BINARY;
            }
        }
        return STRING;
    }

    public final String getName() {
        return this._name;
    }

    public abstract Object getValue(ResultSet var1, String var2) throws SeasarException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _typesByName.put(STRING_NAME, STRING);
        _typesByName.put(INTEGER_NAME, INTEGER);
        _typesByName.put(LONG_NAME, LONG);
        _typesByName.put(DOUBLE_NAME, DOUBLE);
        _typesByName.put(BIGDECIMAL_NAME, BIGDECIMAL);
        _typesByName.put(TIMESTAMP_NAME, TIMESTAMP);
        _typesByName.put(BINARY_NAME, BINARY);
        _typesByClass.put(class$java$lang$String == null ? (class$java$lang$String = ValueType.class$("java.lang.String")) : class$java$lang$String, STRING);
        _typesByClass.put(Integer.TYPE, INTEGER);
        _typesByClass.put(Long.TYPE, LONG);
        _typesByClass.put(Double.TYPE, DOUBLE);
        _typesByClass.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ValueType.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, BIGDECIMAL);
        _typesByClass.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ValueType.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, TIMESTAMP);
        _typesByClass.put(ArrayUtil.EMPTY_BYTES.getClass(), BINARY);
    }

    private static class BinaryType
    extends ValueType {
        BinaryType(String name) {
            super(name);
        }

        public Object getValue(ResultSet rs, String columnName) throws SeasarException {
            try {
                return rs.getBytes(columnName);
            }
            catch (SQLException ex) {
                throw new SeasarException("ESSR0347", new Object[]{columnName, ex}, (Throwable)ex);
            }
        }
    }

    private static class TimestampType
    extends ValueType {
        TimestampType(String name) {
            super(name);
        }

        public Object getValue(ResultSet rs, String columnName) throws SeasarException {
            try {
                return rs.getTimestamp(columnName);
            }
            catch (SQLException ex) {
                throw new SeasarException("ESSR0347", new Object[]{columnName, ex}, (Throwable)ex);
            }
        }
    }

    private static class BigDecimalType
    extends ValueType {
        BigDecimalType(String name) {
            super(name);
        }

        public Object getValue(ResultSet rs, String columnName) throws SeasarException {
            try {
                return rs.getBigDecimal(columnName);
            }
            catch (SQLException ex) {
                throw new SeasarException("ESSR0347", new Object[]{columnName, ex}, (Throwable)ex);
            }
        }
    }

    private static class DoubleType
    extends ValueType {
        DoubleType(String name) {
            super(name);
        }

        public Object getValue(ResultSet rs, String columnName) throws SeasarException {
            try {
                return new Double(rs.getDouble(columnName));
            }
            catch (SQLException ex) {
                throw new SeasarException("ESSR0347", new Object[]{columnName, ex}, (Throwable)ex);
            }
        }
    }

    private static class LongType
    extends ValueType {
        LongType(String name) {
            super(name);
        }

        public Object getValue(ResultSet rs, String columnName) throws SeasarException {
            try {
                return new Long(rs.getLong(columnName));
            }
            catch (SQLException ex) {
                throw new SeasarException("ESSR0347", new Object[]{columnName, ex}, (Throwable)ex);
            }
        }
    }

    private static class IntegerType
    extends ValueType {
        IntegerType(String name) {
            super(name);
        }

        public Object getValue(ResultSet rs, String columnName) throws SeasarException {
            try {
                return new Integer(rs.getInt(columnName));
            }
            catch (SQLException ex) {
                throw new SeasarException("ESSR0347", new Object[]{columnName, ex}, (Throwable)ex);
            }
        }
    }

    private static class StringType
    extends ValueType {
        StringType(String name) {
            super(name);
        }

        public Object getValue(ResultSet rs, String columnName) throws SeasarException {
            try {
                return rs.getString(columnName);
            }
            catch (SQLException ex) {
                throw new SeasarException("ESSR0347", new Object[]{columnName, ex}, (Throwable)ex);
            }
        }
    }
}

