/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import org.seasar.nazuna.AbstractRuleStatement;
import org.seasar.nazuna.Expression;
import org.seasar.nazuna.NewArrayExp;
import org.seasar.nazuna.RuleContext;
import org.seasar.nazuna.RuleParser;
import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public class ThrowTag
extends AbstractRuleStatement {
    private Expression _throwableExp;
    private String _messageCode;
    private NewArrayExp _newArrayExp;

    public ThrowTag(Object parent, String location) {
        super(parent, location);
    }

    public void execute(RuleContext ruleContext) throws SeasarException {
        try {
            this.executeReal(ruleContext);
        }
        catch (Throwable t) {
            ruleContext.setThrowable(t, this.getLocation());
        }
    }

    public final void executeReal(RuleContext ruleContext) throws SeasarException {
        Throwable throwable = this.getThrowable(ruleContext);
        ruleContext.setThrowable(throwable, this.getLocation());
    }

    public final void setMessageCode(String messageCode) {
        Assertion.assertNotNull("messageCode", messageCode);
        this._messageCode = messageCode;
    }

    public final void setArgs(String args) throws SeasarException {
        this._newArrayExp = args != null ? (NewArrayExp)new RuleParser("new java.lang.Object[]{" + args + "}").parseExpression() : NewArrayExp.EMPTY_ARRAY_EXP;
    }

    public final void setThrowableExp(Expression throwableExp) {
        Assertion.assertNotNull("throwableExp", throwableExp);
        this._throwableExp = throwableExp;
    }

    public final Throwable getThrowable(RuleContext ruleContext) throws SeasarException {
        if (this._throwableExp != null) {
            return (Throwable)this._throwableExp.evaluateValue(ruleContext);
        }
        return new SeasarException(this._messageCode, this.getArgs(ruleContext));
    }

    public Object[] getArgs(RuleContext ruleContext) throws SeasarException {
        return (Object[])this._newArrayExp.evaluateValue(ruleContext);
    }
}

