/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.seasar.nazuna.Expression;
import org.seasar.nazuna.RuleContext;
import org.seasar.nazuna.RuleParser;
import org.seasar.util.Conversion;
import org.seasar.util.SeasarException;
import org.seasar.util.StringUtil;

public abstract class TextTagFragment {
    private static final String DELIM = "${}?";

    private TextTagFragment() {
    }

    public static TextTagFragment[] parse(String text) throws SeasarException {
        ArrayList<TextTagFragment> list = new ArrayList<TextTagFragment>();
        StringTokenizer st = new StringTokenizer(text, DELIM, true);
        while (st.hasMoreElements()) {
            String token = st.nextToken();
            if ("$".equals(token) || "?".equals(token)) {
                String s1 = st.nextToken();
                if (!"{".equals(s1)) {
                    throw new SeasarException("ESSR0033", new Object[]{s1, "{"});
                }
                String varName = st.nextToken();
                String s2 = st.nextToken();
                if (!"}".equals(s2)) {
                    throw new SeasarException("ESSR0033", new Object[]{s2, "}"});
                }
                Expression exp = new RuleParser(varName).parseExpression();
                if ("$".equals(token)) {
                    list.add(new ValueFragment(exp));
                    continue;
                }
                list.add(new BindVariableFragment(exp));
                continue;
            }
            list.add(new TextFragment(TextTagFragment.adjustToken(token)));
        }
        return list.toArray(new TextTagFragment[list.size()]);
    }

    public static String replaceToken(String token) {
        token = StringUtil.replace(token, " lt ", " < ");
        token = StringUtil.replace(token, " le ", " <= ");
        token = StringUtil.replace(token, " gt ", " > ");
        token = StringUtil.replace(token, " ge ", " >= ");
        token = StringUtil.replace(token, " eq ", " = ");
        token = StringUtil.replace(token, " ne ", " != ");
        return token;
    }

    public static String adjustToken(String token) {
        StringTokenizer st = new StringTokenizer(token, "'", true);
        if (!st.hasMoreElements()) {
            return token;
        }
        StringBuffer buf = new StringBuffer(token.length());
        block0: do {
            String s;
            if ((s = st.nextToken()).equals("'")) {
                buf.append(s);
                while (st.hasMoreElements()) {
                    String s2 = st.nextToken();
                    if (s2.equals("'")) {
                        if (!st.hasMoreElements()) {
                            buf.append(s2);
                            continue block0;
                        }
                        String s3 = st.nextToken();
                        if (s3.equals("'")) {
                            buf.append("''");
                            continue;
                        }
                        buf.append(s2);
                        buf.append(TextTagFragment.replaceToken(s3));
                        continue block0;
                    }
                    buf.append(s2);
                }
            } else {
                buf.append(TextTagFragment.replaceToken(s));
            }
        } while (st.hasMoreElements());
        return buf.toString();
    }

    public abstract void execute(RuleContext var1) throws SeasarException;

    private static class BindVariableFragment
    extends TextTagFragment {
        private Expression _exp;

        public BindVariableFragment(Expression exp) {
            this._exp = exp;
        }

        public void execute(RuleContext ruleContext) throws SeasarException {
            Object bindVariable = this._exp.evaluateValue(ruleContext);
            ruleContext.addText("?");
            ruleContext.addBindVariable(bindVariable);
        }
    }

    private static class ValueFragment
    extends TextTagFragment {
        private Expression _exp;

        public ValueFragment(Expression exp) {
            this._exp = exp;
        }

        public void execute(RuleContext ruleContext) throws SeasarException {
            String text = Conversion.toString(this._exp.evaluateValue(ruleContext), null);
            ruleContext.addText(text);
        }
    }

    private static class TextFragment
    extends TextTagFragment {
        private String _text;

        public TextFragment(String text) {
            this._text = text;
        }

        public void execute(RuleContext ruleContext) {
            ruleContext.addText(this._text);
        }
    }
}

