/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.util.List;
import java.util.Map;
import org.seasar.nazuna.InputType;
import org.seasar.nazuna.NazunaConstants;
import org.seasar.nazuna.NzRecordSet;
import org.seasar.nazuna.Sqlet;
import org.seasar.nazuna.SqletDeployer;
import org.seasar.util.SMap;
import org.seasar.util.SeasarException;

public final class SqletContainer {
    private static Map _sqletDeployers = new SMap(89);

    private SqletContainer() {
    }

    public static final List executeQuery(String name, Map parameters) throws SeasarException {
        return SqletContainer.getSqlet(name).executeQuery(parameters);
    }

    public static final List executeQuery(String name, Object[] args) throws SeasarException {
        Sqlet sqlet;
        InputType inputType;
        if (args == null) {
            args = NazunaConstants.NULL_ARGS;
        }
        if ((inputType = (sqlet = SqletContainer.getSqlet(name)).getInputType()) == null) {
            return sqlet.executeQuery();
        }
        return sqlet.executeQuery(inputType.convertArgsToMap(args));
    }

    public static final NzRecordSet executeRSQuery(String name, Map parameters) throws SeasarException {
        return SqletContainer.getSqlet(name).executeRSQuery(parameters);
    }

    public static final NzRecordSet executeRSQuery(String name, Object[] args) throws SeasarException {
        Sqlet sqlet;
        InputType inputType;
        if (args == null) {
            args = NazunaConstants.NULL_ARGS;
        }
        if ((inputType = (sqlet = SqletContainer.getSqlet(name)).getInputType()) == null) {
            return sqlet.executeRSQuery();
        }
        return sqlet.executeRSQuery(inputType.convertArgsToMap(args));
    }

    public static final Object executeSingleQuery(String name, Map parameters) throws SeasarException {
        return SqletContainer.getSqlet(name).executeSingleQuery(parameters);
    }

    public static final Object executeSingleQuery(String name, Object[] args) throws SeasarException {
        Sqlet sqlet;
        InputType inputType;
        if (args == null) {
            args = NazunaConstants.NULL_ARGS;
        }
        if ((inputType = (sqlet = SqletContainer.getSqlet(name)).getInputType()) == null) {
            return sqlet.executeSingleQuery();
        }
        return sqlet.executeSingleQuery(inputType.convertArgsToMap(args));
    }

    public static final int executeUpdate(String name, Map parameters) throws SeasarException {
        return SqletContainer.getSqlet(name).executeUpdate(parameters);
    }

    public static final int executeUpdate(String name, Object[] args) throws SeasarException {
        Sqlet sqlet;
        InputType inputType;
        if (args == null) {
            args = NazunaConstants.NULL_ARGS;
        }
        if ((inputType = (sqlet = SqletContainer.getSqlet(name)).getInputType()) == null) {
            return sqlet.executeUpdate();
        }
        return sqlet.executeUpdate(inputType.convertArgsToMap(args));
    }

    public static Sqlet getSqlet(String name) throws SeasarException {
        SqletDeployer deployer = SqletContainer.getSqletDeployer(name);
        deployer.deploy();
        return deployer.getSqlet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SqletDeployer getSqletDeployer(String name) throws SeasarException {
        SqletDeployer deployer = (SqletDeployer)_sqletDeployers.get(name = name.intern());
        if (deployer != null) {
            return deployer;
        }
        Map map = _sqletDeployers;
        synchronized (map) {
            deployer = (SqletDeployer)_sqletDeployers.get(name);
            if (deployer == null) {
                deployer = new SqletDeployer(name);
                _sqletDeployers.put(name, deployer);
            }
        }
        return deployer;
    }
}

