/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.seasar.log.Logger;
import org.seasar.nazuna.MapResultType;
import org.seasar.nazuna.NzRecordSet;
import org.seasar.nazuna.ResultType;
import org.seasar.nazuna.ResultTypeFactory;
import org.seasar.nazuna.RuleBase;
import org.seasar.nazuna.RuleContext;
import org.seasar.nazuna.RuleContextImpl;
import org.seasar.nazuna.RuleStatement;
import org.seasar.util.Conversion;
import org.seasar.util.Reflector;
import org.seasar.util.SeasarContext;
import org.seasar.util.SeasarException;
import org.seasar.util.StringUtil;

public final class Sqlet
extends RuleBase {
    private static Logger _logger = Logger.getLogger(class$org$seasar$nazuna$Sqlet == null ? (class$org$seasar$nazuna$Sqlet = Sqlet.class$("org.seasar.nazuna.Sqlet")) : class$org$seasar$nazuna$Sqlet);
    private static Method _executeQueryRealMethod = Reflector.getMethod(class$org$seasar$nazuna$Sqlet == null ? (class$org$seasar$nazuna$Sqlet = Sqlet.class$("org.seasar.nazuna.Sqlet")) : class$org$seasar$nazuna$Sqlet, "executeQueryReal", new Class[]{class$java$lang$String == null ? (class$java$lang$String = Sqlet.class$("java.lang.String")) : class$java$lang$String, class$java$util$List == null ? (class$java$util$List = Sqlet.class$("java.util.List")) : class$java$util$List});
    private static Method _executeUpdateRealMethod = Reflector.getMethod(class$org$seasar$nazuna$Sqlet == null ? (class$org$seasar$nazuna$Sqlet = Sqlet.class$("org.seasar.nazuna.Sqlet")) : class$org$seasar$nazuna$Sqlet, "executeUpdateReal", new Class[]{class$java$lang$String == null ? (class$java$lang$String = Sqlet.class$("java.lang.String")) : class$java$lang$String, class$java$util$List == null ? (class$java$util$List = Sqlet.class$("java.util.List")) : class$java$util$List});
    private SeasarContext _seasarContext;
    private ResultType _resultType;
    static /* synthetic */ Class class$org$seasar$nazuna$Sqlet;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$List;

    public Sqlet(String contextName, String resultPath) {
        this._seasarContext = SeasarContext.getInstance(contextName);
        if (!StringUtil.isEmpty(resultPath)) {
            this._resultType = ResultTypeFactory.getResultType(resultPath);
        }
    }

    public static void close(ResultSet rs, Statement stmt, Connection con) throws SeasarException {
        SQLException se = null;
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                se = ex;
                _logger.log(ex);
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException ex) {
                se = ex;
                _logger.log(ex);
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException ex) {
                se = ex;
                _logger.log(ex);
            }
        }
        if (se != null) {
            throw SeasarException.convertSeasarException(se);
        }
    }

    public static void setBindVariable(PreparedStatement ps, int index, Object value) throws SeasarException {
        try {
            if (value != null) {
                if (value instanceof String) {
                    ps.setString(index, (String)value);
                } else if (value instanceof Integer) {
                    ps.setInt(index, (Integer)value);
                } else if (value instanceof BigDecimal) {
                    ps.setBigDecimal(index, (BigDecimal)value);
                } else if (value instanceof Long) {
                    ps.setLong(index, (Long)value);
                } else if (value instanceof Timestamp) {
                    ps.setTimestamp(index, (Timestamp)value);
                } else if (value instanceof Date) {
                    ps.setTimestamp(index, Conversion.toTimestamp(value, null));
                } else {
                    ps.setString(index, value.toString());
                }
            } else {
                ps.setNull(index, 12);
            }
        }
        catch (SQLException ex) {
            throw SeasarException.convertSeasarException(ex);
        }
    }

    public static String getBindVariableText(Object bindVariable) {
        if (bindVariable instanceof String) {
            return "'" + bindVariable + "'";
        }
        if (bindVariable instanceof Number) {
            return bindVariable.toString();
        }
        if (bindVariable instanceof Timestamp) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh.mm.ss");
            return "'" + sdf.format((Date)bindVariable) + "'";
        }
        if (bindVariable instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return "'" + sdf.format((Date)bindVariable) + "'";
        }
        if (bindVariable == null) {
            return "null";
        }
        return "'" + bindVariable.toString() + "'";
    }

    public static String getCompleteText(String text, List bindVariables) {
        if (bindVariables == null || bindVariables.size() == 0) {
            return text;
        }
        StringBuffer buf = new StringBuffer(200);
        int pos = 0;
        int pos2 = 0;
        int index = 0;
        while ((pos = text.indexOf(63, pos2)) > 0) {
            buf.append(text.substring(pos2, pos));
            buf.append(Sqlet.getBindVariableText(bindVariables.get(index++)));
            pos2 = pos + 1;
        }
        buf.append(text.substring(pos2));
        return buf.toString();
    }

    public static PreparedStatement getPreparedStatement(Connection con, String text, List bindVariables) throws SeasarException {
        try {
            if (_logger.isDebugEnabled()) {
                _logger.debug(Sqlet.getCompleteText(text, bindVariables));
            }
            PreparedStatement ps = con.prepareStatement(text);
            if (bindVariables != null) {
                for (int i = 0; i < bindVariables.size(); ++i) {
                    Sqlet.setBindVariable(ps, i + 1, bindVariables.get(i));
                }
            }
            return ps;
        }
        catch (SQLException ex) {
            throw new SeasarException("ESSR0008", new Object[]{Sqlet.getCompleteText(text, bindVariables), ex}, (Throwable)ex);
        }
    }

    public ResultType getResultType() {
        return this._resultType;
    }

    public List executeQuery() throws SeasarException {
        return this.executeQuery(null);
    }

    public List executeQuery(Map parameters) throws SeasarException {
        RuleContext ruleContext = this.execute(parameters);
        String text = ruleContext.getText();
        List bindVariables = ruleContext.getBindVariables();
        return this.executeQuery(text, bindVariables);
    }

    public List executeQuery(String text, List bindVariables) throws SeasarException {
        return (List)this.getTransAttribute().invoke(_executeQueryRealMethod, this, new Object[]{text, bindVariables});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List executeQueryReal(String text, List bindVariables) throws SeasarException {
        Object object;
        Connection con = this._seasarContext.getConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = Sqlet.getPreparedStatement(con, text, bindVariables);
            rs = ps.executeQuery();
            if (this._resultType == null) {
                object = this;
                synchronized (object) {
                    if (this._resultType == null) {
                        this._resultType = MapResultType.create(rs.getMetaData());
                    }
                }
            }
            object = this._resultType.fetch(rs);
        }
        catch (SQLException ex) {
            try {
                throw SeasarException.convertSeasarException(ex);
            }
            catch (Throwable throwable) {
                Sqlet.close(rs, ps, con);
                throw throwable;
            }
        }
        Sqlet.close(rs, ps, con);
        return object;
    }

    public NzRecordSet executeRSQuery() throws SeasarException {
        return this.executeRSQuery(null);
    }

    public NzRecordSet executeRSQuery(Map parameters) throws SeasarException {
        List rows = this.executeQuery(parameters);
        return new NzRecordSet(this._resultType.getPropertyNames(), rows);
    }

    public Object executeSingleQuery() throws SeasarException {
        return this.executeSingleQuery(null);
    }

    public Object executeSingleQuery(Map parameters) throws SeasarException {
        List rows = this.executeQuery(parameters);
        return Sqlet.getSingle(rows);
    }

    public int executeUpdate() throws SeasarException {
        return this.executeUpdate(null);
    }

    public int executeUpdate(Map parameters) throws SeasarException {
        RuleContext ruleContext = this.execute(parameters);
        String text = ruleContext.getText();
        List bindVariables = ruleContext.getBindVariables();
        return this.executeUpdate(text, bindVariables);
    }

    public int executeUpdate(String text, List bindVariables) throws SeasarException {
        return (Integer)this.getTransAttribute().invoke(_executeUpdateRealMethod, this, new Object[]{text, bindVariables});
    }

    public int executeUpdateReal(String text, List bindVariables) throws SeasarException {
        Connection con = this._seasarContext.getConnection();
        PreparedStatement ps = null;
        try {
            ps = Sqlet.getPreparedStatement(con, text, bindVariables);
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException ex) {
            throw SeasarException.convertSeasarException(ex);
        }
        finally {
            Sqlet.close(null, ps, con);
        }
    }

    public RuleContext execute() throws SeasarException {
        return this.execute(null);
    }

    public RuleContext execute(Map parameters) throws SeasarException {
        RuleContextImpl ctx = new RuleContextImpl(this, parameters);
        for (int i = 0; i < this._ruleStatements.length; ++i) {
            RuleStatement ruleStatement = this._ruleStatements[i];
            ruleStatement.execute(ctx);
            if (!ctx.isThrowed()) continue;
            ctx.throwSeasarExcepton();
        }
        return ctx;
    }

    private static Object getSingle(List results) throws SeasarException {
        int size = results.size();
        switch (size) {
            case 1: {
                return results.get(0);
            }
            case 0: {
                return null;
            }
        }
        throw new SeasarException("ESSR0362");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

