/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

public abstract class SortType {
    public static final SortType ASC = new Asc();
    public static final SortType DESC = new Desc();

    private SortType() {
    }

    abstract int compare(Object var1, Object var2);

    private static class Desc
    extends SortType {
        private Desc() {
        }

        int compare(Object o1, Object o2) {
            Comparable c1 = (Comparable)o1;
            Comparable c2 = (Comparable)o2;
            if (c1 != null && c2 != null) {
                return c2.compareTo(c1);
            }
            if (c1 == null && c2 == null) {
                return 0;
            }
            if (c2 == null) {
                return 1;
            }
            return -1;
        }
    }

    private static class Asc
    extends SortType {
        private Asc() {
        }

        int compare(Object o1, Object o2) {
            Comparable c1 = (Comparable)o1;
            Comparable c2 = (Comparable)o2;
            if (c1 != null && c2 != null) {
                return c1.compareTo(c2);
            }
            if (c1 == null && c2 == null) {
                return 0;
            }
            if (c1 == null) {
                return 1;
            }
            return -1;
        }
    }
}

