/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.util.List;
import org.seasar.nazuna.RuleTokenizer;
import org.seasar.nazuna.SortElement;
import org.seasar.nazuna.SortType;
import org.seasar.util.Assertion;
import org.seasar.util.EArrayList;
import org.seasar.util.SeasarException;
import org.seasar.util.Sorter;

public final class SortDesc {
    private Sorter _sorter;

    public SortDesc(String clause) throws SeasarException {
        Assertion.assertNotNull("clause", clause);
        EArrayList sortElementList = new EArrayList();
        RuleTokenizer tokenizer = new RuleTokenizer(clause);
        int token = tokenizer.nextToken();
        while (token != 99) {
            String propertyName = tokenizer.getString();
            token = tokenizer.nextToken();
            SortType sortType = SortType.ASC;
            switch (token) {
                case 69: {
                    tokenizer.nextToken();
                    sortType = SortType.ASC;
                    break;
                }
                case 70: {
                    tokenizer.nextToken();
                    sortType = SortType.DESC;
                }
            }
            sortElementList.add(new SortElement(propertyName, sortType));
            token = tokenizer.nextToken();
            if (token != 22) continue;
            token = tokenizer.nextToken();
        }
        this._sorter = new Calculator(sortElementList.toArray((T[])new SortElement[sortElementList.size()]));
    }

    public SortDesc(SortElement[] sortElements) {
        Assertion.assertNotNull("sortElements", sortElements);
        this._sorter = new Calculator(sortElements);
    }

    public List sort(List items) {
        Assertion.assertNotNull("items", items);
        Object[] array = items.toArray();
        this._sorter.sort(array);
        return new EArrayList(array);
    }

    private class Calculator
    extends Sorter {
        private SortElement[] _sortElements;

        Calculator(SortElement[] sortElements) {
            this._sortElements = sortElements;
        }

        protected int doCompare(Object o1, Object o2) {
            for (int i = 0; i < this._sortElements.length; ++i) {
                SortElement sortElement = this._sortElements[i];
                int result = sortElement.compare(o1, o2);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }
}

