/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.seasar.nazuna.MandatoryTx;
import org.seasar.nazuna.NazunaTransAttribute;
import org.seasar.nazuna.NazunaUtil;
import org.seasar.nazuna.RequiredTx;
import org.seasar.nazuna.RequiresNewTx;
import org.seasar.nazuna.Rulet;
import org.seasar.util.Assertion;
import org.seasar.util.Reflector;
import org.seasar.util.SeasarException;
import org.seasar.util.SeasarRuntimeException;

public final class RuletFacade {
    private static final String DEFAULT_ARG_NAME = "DEFAULT_ARG";
    private Rulet _rulet;
    private Method _doExecuteMethod;
    private Method _doValidateMethod;
    private Object[] _defaultArgs;
    private NazunaTransAttribute _transAttribute;
    static /* synthetic */ Class class$org$seasar$nazuna$Rulet;

    private RuletFacade(Rulet rulet, Method doExecuteMethod, Method doValidateMethod, Object[] defaultArgs, NazunaTransAttribute transAttribute) {
        this._rulet = rulet;
        this._doExecuteMethod = doExecuteMethod;
        this._doValidateMethod = doValidateMethod;
        this._defaultArgs = defaultArgs;
        this._transAttribute = transAttribute;
    }

    public static final RuletFacade create(Class ruletClass) {
        Assertion.assertNotNull("ruletClass", ruletClass);
        Rulet rulet = (Rulet)Reflector.newInstance(ruletClass);
        Method doExecuteMethod = RuletFacade.getMethod(ruletClass, "doExecute");
        Assertion.assertFound("doExecute", doExecuteMethod);
        Method doValidateMethod = RuletFacade.getMethod(ruletClass, "doValidate");
        Object[] defaultArgs = RuletFacade.getDefaultArgs(ruletClass, doExecuteMethod.getParameterTypes().length);
        NazunaTransAttribute transAttribute = RuletFacade.getTransAttribute(rulet);
        return new RuletFacade(rulet, doExecuteMethod, doValidateMethod, defaultArgs, transAttribute);
    }

    public final Object getRulet() {
        return this._rulet;
    }

    public final Method getDoExecuteMethod() {
        return this._doExecuteMethod;
    }

    public final Method getDoValidateMethod() {
        return this._doValidateMethod;
    }

    public final NazunaTransAttribute getTransAttribute() {
        return this._transAttribute;
    }

    public final void setTransAttribute(NazunaTransAttribute transAttribute) {
        Assertion.assertNotNull("transAttribute", transAttribute);
        this._transAttribute = transAttribute;
    }

    public final void init() throws SeasarException {
        this._rulet.init();
    }

    public final void destroy() throws SeasarException {
        this._rulet.destroy();
    }

    public final Object executeRulet(Object[] args) throws SeasarException {
        args = this.convertArgs(args);
        if (this._doValidateMethod != null) {
            Reflector.invoke(this._doValidateMethod, this._rulet, args);
        }
        return this._transAttribute.invoke(this._doExecuteMethod, this._rulet, args);
    }

    private static final Method getMethod(Class ruletClass, String methodName) {
        Method[] methods = ruletClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            return methods[i];
        }
        Class superClass = ruletClass.getSuperclass();
        if (superClass != null && !superClass.equals(class$org$seasar$nazuna$Rulet == null ? (class$org$seasar$nazuna$Rulet = RuletFacade.class$("org.seasar.nazuna.Rulet")) : class$org$seasar$nazuna$Rulet)) {
            return RuletFacade.getMethod(superClass, methodName);
        }
        return null;
    }

    private static final Object getFieldValue(Class ruletClass, String fieldName) {
        Field[] fields = ruletClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals(fieldName)) continue;
            try {
                return fields[i].get(ruletClass);
            }
            catch (IllegalAccessException ex) {
                throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
            }
        }
        Class superClass = ruletClass.getSuperclass();
        if (superClass != null && !superClass.equals(class$org$seasar$nazuna$Rulet == null ? (class$org$seasar$nazuna$Rulet = RuletFacade.class$("org.seasar.nazuna.Rulet")) : class$org$seasar$nazuna$Rulet)) {
            return RuletFacade.getFieldValue(superClass, fieldName);
        }
        return null;
    }

    private static final NazunaTransAttribute getTransAttribute(Object rulet) {
        if (rulet instanceof RequiredTx) {
            return NazunaTransAttribute.REQUIRED;
        }
        if (rulet instanceof RequiresNewTx) {
            return NazunaTransAttribute.REQUIRES_NEW;
        }
        if (rulet instanceof MandatoryTx) {
            return NazunaTransAttribute.MANDATORY;
        }
        return NazunaTransAttribute.SUPPORTS;
    }

    private static final Object[] getDefaultArgs(Class ruletClass, int argSize) {
        Object[] args = new Object[argSize];
        for (int i = 0; i < argSize; ++i) {
            args[i] = RuletFacade.getFieldValue(ruletClass, DEFAULT_ARG_NAME + i);
        }
        return args;
    }

    private final Object[] convertArgs(Object[] args) {
        Class<?>[] parameterTypes = this._doExecuteMethod.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            args[i] = NazunaUtil.adjustValue(args[i], parameterTypes[i]);
        }
        Object[] args2 = args;
        if (args.length < this._defaultArgs.length) {
            args2 = new Object[this._defaultArgs.length];
            System.arraycopy(args, 0, args2, 0, args.length);
        }
        for (int i = args.length; i < this._defaultArgs.length; ++i) {
            args2[i] = this._defaultArgs[i];
        }
        return args2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

