/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.io.File;
import org.seasar.nazuna.RuletClassLoader;
import org.seasar.nazuna.RuletCompiler;
import org.seasar.nazuna.RuletFacade;
import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class RuletDeployer {
    private String _className;
    private File _srcFile;
    private File _classFile;
    private RuletFacade _ruletFacade;
    private long _lastModified = 0L;

    public RuletDeployer(String className) {
        Assertion.assertNotNull("className", className);
        this._className = className;
        this._srcFile = RuletCompiler.getSrcFile(className);
        this._classFile = RuletCompiler.getClassFile(className);
    }

    public static final RuletFacade createRuletFacade(Class clazz) throws SeasarException {
        RuletFacade facade = RuletFacade.create(clazz);
        facade.init();
        return facade;
    }

    public final RuletFacade getRuletFacade() throws SeasarException {
        return this._ruletFacade;
    }

    public final File getSrcFile() {
        return this._srcFile;
    }

    public final File getClassFile() {
        return this._classFile;
    }

    public final String getClassName() {
        return this._className;
    }

    public final long getLastModified() {
        return this._lastModified;
    }

    public final void setLastModified(long lastModified) {
        this._lastModified = lastModified;
    }

    public final synchronized void deploy() throws SeasarException {
        if (this._srcFile.exists() && this._classFile.exists()) {
            if (this._classFile.lastModified() >= this._srcFile.lastModified()) {
                if (this._classFile.lastModified() > this._lastModified) {
                    this.deployFromClass();
                }
            } else if (this._srcFile.lastModified() > this._lastModified) {
                this.deployFromSrc();
            }
        } else if (this._srcFile.exists()) {
            if (this._srcFile.lastModified() > this._lastModified) {
                this.deployFromSrc();
            }
        } else if (this._classFile.exists()) {
            if (this._classFile.lastModified() > this._lastModified) {
                this.deployFromClass();
            }
        } else {
            throw new SeasarException("ESSR0001", new Object[]{this._className});
        }
    }

    public final Class defineClass() throws SeasarException {
        RuletClassLoader loader = new RuletClassLoader();
        return loader.defineClass(this._className, this._classFile);
    }

    public final void deployFromSrc() throws SeasarException {
        this.destroy();
        RuletCompiler.compile(this._srcFile, this._classFile);
        Class ruletClass = this.defineClass();
        this._lastModified = this._srcFile.lastModified();
        this._ruletFacade = RuletDeployer.createRuletFacade(ruletClass);
    }

    public final void deployFromClass() throws SeasarException {
        this.destroy();
        Class ruletClass = this.defineClass();
        this._lastModified = this._classFile.lastModified();
        this._ruletFacade = RuletDeployer.createRuletFacade(ruletClass);
    }

    public final void destroy() throws SeasarException {
        if (this._ruletFacade != null) {
            this._ruletFacade.destroy();
            this._ruletFacade = null;
        }
    }
}

