/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.seasar.log.Logger;
import org.seasar.nazuna.RuletDeployer;
import org.seasar.nazuna.RuletFacade;
import org.seasar.util.ArrayUtil;
import org.seasar.util.SeasarException;

public final class RuletContainer {
    private static Map _ruletDeployers = new HashMap(89);
    static /* synthetic */ Class class$org$seasar$nazuna$RuletContainer;

    private RuletContainer() {
    }

    public static final Object executeRulet(String className, Object[] args) throws SeasarException {
        if (args == null) {
            args = ArrayUtil.EMPTY_OBJECTS;
        }
        return RuletContainer.getRuletFacade(className).executeRulet(args);
    }

    public static final RuletFacade getRuletFacade(String className) throws SeasarException {
        RuletDeployer deployer = RuletContainer.getRuletDeployer(className);
        deployer.deploy();
        return deployer.getRuletFacade();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final RuletDeployer getRuletDeployer(String className) {
        RuletDeployer deployer = (RuletDeployer)_ruletDeployers.get(className = className.intern());
        if (deployer != null) {
            return deployer;
        }
        Map map = _ruletDeployers;
        synchronized (map) {
            deployer = (RuletDeployer)_ruletDeployers.get(className);
            if (deployer != null) {
                return deployer;
            }
            deployer = new RuletDeployer(className);
            _ruletDeployers.put(className, deployer);
        }
        return deployer;
    }

    public static final synchronized void destroyAll() {
        Iterator i = _ruletDeployers.keySet().iterator();
        while (i.hasNext()) {
            String className = (String)i.next();
            RuletDeployer deployer = (RuletDeployer)_ruletDeployers.get(className);
            try {
                deployer.destroy();
            }
            catch (Throwable t) {
                Logger.getLogger(class$org$seasar$nazuna$RuletContainer == null ? RuletContainer.class$("org.seasar.nazuna.RuletContainer") : class$org$seasar$nazuna$RuletContainer).log(t);
            }
        }
        _ruletDeployers.clear();
    }

    private static void addShutdownHook() {
        Thread t = new Thread(){

            public void run() {
                RuletContainer.destroyAll();
            }
        };
        t.setDaemon(true);
        try {
            Runtime.getRuntime().addShutdownHook(t);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        RuletContainer.addShutdownHook();
    }
}

