/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.util.Map;
import org.seasar.nazuna.NazunaTokenizer;
import org.seasar.util.SMap;
import org.seasar.util.SeasarException;
import org.seasar.util.SeasarRuntimeException;

public final class RuleTokenizer {
    public static final int INVALID_CHAR = -1;
    public static final int OR = 1;
    public static final int AND = 2;
    public static final int NOT = 3;
    public static final int WORD = 4;
    public static final int QUOTED_STRING = 5;
    public static final int INTEGER = 6;
    public static final int LONG = 7;
    public static final int DOUBLE = 8;
    public static final int LEFT_PAREN = 9;
    public static final int RIGHT_PAREN = 10;
    public static final int ADD = 11;
    public static final int SUBTRACT = 12;
    public static final int MULTIPLY = 13;
    public static final int DIVIDE = 14;
    public static final int MOD = 15;
    public static final int EQUAL = 16;
    public static final int NOT_EQUAL = 17;
    public static final int GREATER_THAN = 18;
    public static final int GREATER_EQUAL = 19;
    public static final int LESS_THAN = 20;
    public static final int LESS_EQUAL = 21;
    public static final int COMMA = 22;
    public static final int NEW = 23;
    public static final int FROM = 24;
    public static final int IN = 25;
    public static final int BETWEEN = 26;
    public static final int TO_TIMESTAMP = 27;
    public static final int TO_STRING = 28;
    public static final int TO_BIGDECIMAL = 29;
    public static final int TO_LONG = 30;
    public static final int TO_INTEGER = 31;
    public static final int FOR = 32;
    public static final int ASSIGN = 33;
    public static final int NOW = 34;
    public static final int TRUE = 35;
    public static final int FALSE = 36;
    public static final int CASE = 37;
    public static final int IS = 38;
    public static final int NULL = 39;
    public static final int LIKE = 40;
    public static final int COALESCE = 41;
    public static final int EXECUTE = 42;
    public static final int CONCATENATE = 43;
    public static final int NULLIF = 44;
    public static final int NVL = 45;
    public static final int TRIM = 46;
    public static final int TO_BOOLEAN = 48;
    public static final int MATCH = 49;
    public static final int MATCH_IGNORE_CASE = 50;
    public static final int LEFT_BRACKET = 51;
    public static final int RIGHT_BRACKET = 52;
    public static final int LEFT_BRACE = 53;
    public static final int RIGHT_BRACE = 54;
    public static final int LEADING = 55;
    public static final int TRAILING = 56;
    public static final int BOTH = 57;
    public static final int POSITION = 58;
    public static final int SUBSTRING = 59;
    public static final int WHEN = 60;
    public static final int THEN = 61;
    public static final int ELSE = 62;
    public static final int END = 63;
    public static final int NOT_MATCH = 64;
    public static final int NOT_MATCH_IGNORE_CASE = 65;
    public static final int EXECUTE_QUERY = 66;
    public static final int EXECUTE_UPDATE = 67;
    public static final int TO_DOUBLE = 68;
    public static final int ASC = 69;
    public static final int DESC = 70;
    public static final int COUNT = 71;
    public static final int SUM = 72;
    public static final int MAX = 73;
    public static final int MIN = 74;
    public static final int AVG = 75;
    public static final int AS = 76;
    public static final int EXECUTE_RULET = 77;
    public static final int EXECUTE_RS_QUERY = 78;
    public static final int EXECUTE_SINGLE_QUERY = 79;
    public static final int EOF = 99;
    private static Map _wordMap = new SMap();
    private transient NazunaTokenizer _tokenizer;

    public RuleTokenizer(String s) {
        this._tokenizer = new NazunaTokenizer(s);
    }

    public static void assertToken(int expected, int real) {
        if (expected != real) {
            throw new SeasarRuntimeException("ESSR0002", new Object[]{"token", RuleTokenizer.getTokenName(expected), RuleTokenizer.getTokenName(real)});
        }
    }

    public int nextToken() throws SeasarException {
        try {
            switch (this._tokenizer.nextToken()) {
                case -1: {
                    return 99;
                }
                case -3: {
                    Integer type = (Integer)_wordMap.get(this._tokenizer.sval.toLowerCase());
                    if (type != null) {
                        return type;
                    }
                    return 4;
                }
                case -11: {
                    return 6;
                }
                case -12: {
                    return 7;
                }
                case -13: {
                    return 8;
                }
                case 39: {
                    return 5;
                }
                case 40: {
                    return 9;
                }
                case 41: {
                    return 10;
                }
                case 43: {
                    return 11;
                }
                case 45: {
                    return 12;
                }
                case 47: {
                    return 14;
                }
                case 37: {
                    return 15;
                }
                case 44: {
                    return 22;
                }
                case 91: {
                    return 51;
                }
                case 93: {
                    return 52;
                }
                case 123: {
                    return 53;
                }
                case 125: {
                    return 54;
                }
            }
            throw new SeasarException("ESSR0313", new Object[]{String.valueOf(this._tokenizer.ttype)});
        }
        catch (Exception ex) {
            throw SeasarException.convertSeasarException(ex);
        }
    }

    public int nextToken(int t) throws SeasarException {
        int next = this.nextToken();
        RuleTokenizer.assertToken(t, next);
        return next;
    }

    public String getString() {
        return this._tokenizer.sval;
    }

    public Integer getInteger() {
        return this._tokenizer.ival;
    }

    public Long getLong() {
        return this._tokenizer.lval;
    }

    public Double getDouble() {
        return this._tokenizer.dval;
    }

    public String toString() {
        return this._tokenizer.toString();
    }

    public static String getTokenName(int t) {
        switch (t) {
            case 11: {
                return "ADD";
            }
            case 12: {
                return "SUBTRACT";
            }
            case 13: {
                return "MULTIPLY";
            }
            case 14: {
                return "DIVIDE";
            }
            case 15: {
                return "MOD";
            }
            case 9: {
                return "LEFT_PAREN";
            }
            case 10: {
                return "RIGHT_PAREN";
            }
            case 2: {
                return "AND";
            }
            case 1: {
                return "OR";
            }
            case 3: {
                return "NOT";
            }
            case 5: {
                return "QUOTED_STRING";
            }
            case 99: {
                return "EOF";
            }
            case 4: {
                return "WORD";
            }
            case 6: {
                return "INTEGER";
            }
            case 7: {
                return "LONG";
            }
            case 8: {
                return "DOUBLE";
            }
            case 27: {
                return "TO_TIMESTAMP";
            }
            case 28: {
                return "TO_STRING";
            }
            case 29: {
                return "TO_BIGDECIMAL";
            }
            case 68: {
                return "TO_DOUBLE";
            }
            case 30: {
                return "TO_LONG";
            }
            case 31: {
                return "TO_INTEGER";
            }
            case 48: {
                return "TO_BOOLEAN";
            }
            case 34: {
                return "NOW";
            }
            case 16: {
                return "EQUAL";
            }
            case 17: {
                return "NOT_EQUAL";
            }
            case 18: {
                return "GREATER_THAN";
            }
            case 19: {
                return "GREATER_EQUAL";
            }
            case 20: {
                return "LESS_THAN";
            }
            case 21: {
                return "LESS_EQUAL";
            }
            case 22: {
                return "COMMA";
            }
            case 59: {
                return "SUBSTRING";
            }
            case 25: {
                return "IN";
            }
            case 26: {
                return "BETWEEN";
            }
            case 35: {
                return "TRUE";
            }
            case 36: {
                return "FALSE";
            }
            case 37: {
                return "CASE";
            }
            case 38: {
                return "IS";
            }
            case 39: {
                return "NULL";
            }
            case 40: {
                return "LIKE";
            }
            case 41: {
                return "COALESCE";
            }
            case 58: {
                return "POSITION";
            }
            case 24: {
                return "FROM";
            }
            case 32: {
                return "FOR";
            }
            case 43: {
                return "CONCATENATE";
            }
            case 45: {
                return "NVL";
            }
            case 44: {
                return "NULLIF";
            }
            case 46: {
                return "TRIM";
            }
            case 49: {
                return "MATCH";
            }
            case 50: {
                return "MATCH_IGNORE_CASE";
            }
            case 64: {
                return "NOT_MATCH";
            }
            case 65: {
                return "NOT_MATCH_IGNORE_CASE";
            }
            case 55: {
                return "LEADING";
            }
            case 56: {
                return "TRAILING";
            }
            case 57: {
                return "BOTH";
            }
            case 60: {
                return "WHEN";
            }
            case 61: {
                return "THEN";
            }
            case 62: {
                return "ELSE";
            }
            case 63: {
                return "END";
            }
            case 23: {
                return "NEW";
            }
            case 33: {
                return "ASSIGN";
            }
            case 42: {
                return "EXECUTE";
            }
            case 66: {
                return "EXECUTE_QUERY";
            }
            case 78: {
                return "EXECUTE_RS_QUERY";
            }
            case 79: {
                return "EXECUTE_SINGLE_QUERY";
            }
            case 67: {
                return "EXECUTE_UPDATE";
            }
            case 77: {
                return "EXECUTE_RULET";
            }
            case 69: {
                return "ASC";
            }
            case 70: {
                return "DESC";
            }
            case 71: {
                return "COUNT";
            }
            case 72: {
                return "SUM";
            }
            case 73: {
                return "MAX";
            }
            case 74: {
                return "MIN";
            }
            case 75: {
                return "AVG";
            }
            case 76: {
                return "AS";
            }
        }
        throw new SeasarRuntimeException("ESSR0027", new Object[]{String.valueOf(t)});
    }

    private static void setupWord() {
        _wordMap.put("or", new Integer(1));
        _wordMap.put("and", new Integer(2));
        _wordMap.put("not", new Integer(3));
        _wordMap.put("=", new Integer(16));
        _wordMap.put("eq", new Integer(16));
        _wordMap.put("!=", new Integer(17));
        _wordMap.put("<>", new Integer(17));
        _wordMap.put("ne", new Integer(17));
        _wordMap.put(">", new Integer(18));
        _wordMap.put("gt", new Integer(18));
        _wordMap.put(">=", new Integer(19));
        _wordMap.put("ge", new Integer(19));
        _wordMap.put("<", new Integer(20));
        _wordMap.put("lt", new Integer(20));
        _wordMap.put("<=", new Integer(21));
        _wordMap.put("le", new Integer(21));
        _wordMap.put(":=", new Integer(33));
        _wordMap.put("||", new Integer(43));
        _wordMap.put("to_timestamp", new Integer(27));
        _wordMap.put("to_string", new Integer(28));
        _wordMap.put("to_bigdecimal", new Integer(29));
        _wordMap.put("to_double", new Integer(68));
        _wordMap.put("to_long", new Integer(30));
        _wordMap.put("to_integer", new Integer(31));
        _wordMap.put("to_boolean", new Integer(48));
        _wordMap.put("in", new Integer(25));
        _wordMap.put("between", new Integer(26));
        _wordMap.put("true", new Integer(35));
        _wordMap.put("false", new Integer(36));
        _wordMap.put("case", new Integer(37));
        _wordMap.put("is", new Integer(38));
        _wordMap.put("null", new Integer(39));
        _wordMap.put("like", new Integer(40));
        _wordMap.put("coalesce", new Integer(41));
        _wordMap.put("from", new Integer(24));
        _wordMap.put("for", new Integer(32));
        _wordMap.put("now", new Integer(34));
        _wordMap.put("nvl", new Integer(45));
        _wordMap.put("nullif", new Integer(44));
        _wordMap.put("trim", new Integer(46));
        _wordMap.put("leading", new Integer(55));
        _wordMap.put("trailing", new Integer(56));
        _wordMap.put("both", new Integer(57));
        _wordMap.put("position", new Integer(58));
        _wordMap.put("substring", new Integer(59));
        _wordMap.put("when", new Integer(60));
        _wordMap.put("then", new Integer(61));
        _wordMap.put("else", new Integer(62));
        _wordMap.put("end", new Integer(63));
        _wordMap.put("new", new Integer(23));
        _wordMap.put("execute", new Integer(42));
        _wordMap.put("executequery", new Integer(66));
        _wordMap.put("executersquery", new Integer(78));
        _wordMap.put("executesinglequery", new Integer(79));
        _wordMap.put("executeupdate", new Integer(67));
        _wordMap.put("executerulet", new Integer(77));
        _wordMap.put("*", new Integer(13));
        _wordMap.put("~", new Integer(49));
        _wordMap.put("~*", new Integer(50));
        _wordMap.put("!~", new Integer(64));
        _wordMap.put("!~*", new Integer(65));
        _wordMap.put("asc", new Integer(69));
        _wordMap.put("desc", new Integer(70));
        _wordMap.put("count", new Integer(71));
        _wordMap.put("sum", new Integer(72));
        _wordMap.put("max", new Integer(73));
        _wordMap.put("min", new Integer(74));
        _wordMap.put("avg", new Integer(75));
        _wordMap.put("as", new Integer(76));
    }

    static {
        RuleTokenizer.setupWord();
    }
}

