/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.util.ArrayList;
import org.seasar.nazuna.AddSubExp;
import org.seasar.nazuna.AliasConfig;
import org.seasar.nazuna.AndExp;
import org.seasar.nazuna.BetweenExp;
import org.seasar.nazuna.BooleanExp;
import org.seasar.nazuna.BooleanExpression;
import org.seasar.nazuna.CaseExp;
import org.seasar.nazuna.CoalesceExp;
import org.seasar.nazuna.ConcatenateExp;
import org.seasar.nazuna.DoubleExp;
import org.seasar.nazuna.EqualExp;
import org.seasar.nazuna.ExecuteExp;
import org.seasar.nazuna.ExecuteQueryExp;
import org.seasar.nazuna.ExecuteRSQueryExp;
import org.seasar.nazuna.ExecuteRuletExp;
import org.seasar.nazuna.ExecuteSingleQueryExp;
import org.seasar.nazuna.ExecuteUpdateExp;
import org.seasar.nazuna.Expression;
import org.seasar.nazuna.GetArrayVariableExp;
import org.seasar.nazuna.GetVariableExp;
import org.seasar.nazuna.GreaterEqualExp;
import org.seasar.nazuna.GreaterThanExp;
import org.seasar.nazuna.InExp;
import org.seasar.nazuna.IntegerExp;
import org.seasar.nazuna.IsFalseExp;
import org.seasar.nazuna.IsNotNullExp;
import org.seasar.nazuna.IsNullExp;
import org.seasar.nazuna.IsTrueExp;
import org.seasar.nazuna.LessEqualExp;
import org.seasar.nazuna.LessThanExp;
import org.seasar.nazuna.LikeExp;
import org.seasar.nazuna.LongExp;
import org.seasar.nazuna.MatchExp;
import org.seasar.nazuna.MethodExp;
import org.seasar.nazuna.MultDivModExp;
import org.seasar.nazuna.Nazuna;
import org.seasar.nazuna.NazunaUtil;
import org.seasar.nazuna.NewArrayExp;
import org.seasar.nazuna.NewExp;
import org.seasar.nazuna.NotBetweenExp;
import org.seasar.nazuna.NotEqualExp;
import org.seasar.nazuna.NotExp;
import org.seasar.nazuna.NowExp;
import org.seasar.nazuna.NullExp;
import org.seasar.nazuna.NullifExp;
import org.seasar.nazuna.NvlExp;
import org.seasar.nazuna.OrExp;
import org.seasar.nazuna.RuleTokenizer;
import org.seasar.nazuna.SetArrayVariableExp;
import org.seasar.nazuna.SetVariableExp;
import org.seasar.nazuna.StringExp;
import org.seasar.nazuna.ToBigDecimalExp;
import org.seasar.nazuna.ToBooleanExp;
import org.seasar.nazuna.ToDoubleExp;
import org.seasar.nazuna.ToIntegerExp;
import org.seasar.nazuna.ToLongExp;
import org.seasar.nazuna.ToStringExp;
import org.seasar.nazuna.ToTimestampExp;
import org.seasar.util.EArrayList;
import org.seasar.util.EMap;
import org.seasar.util.Reflector;
import org.seasar.util.SeasarException;

public final class RuleParser {
    private transient RuleTokenizer _tokenizer;
    private int _token;

    public RuleParser(String s) throws SeasarException {
        this._tokenizer = new RuleTokenizer(s);
        this.nextToken();
    }

    public synchronized BooleanExpression parseBooleanExpression() throws SeasarException {
        BooleanExpression boolExp = this.getOrExp();
        this.expect(99);
        return boolExp;
    }

    public synchronized Expression parseExpression() throws SeasarException {
        Expression exp = this.getAddSubExp();
        this.expect(99);
        return exp;
    }

    private BooleanExpression getOrExp() throws SeasarException {
        BooleanExpression left = this.getAndExp();
        while (this._token == 1) {
            this.nextToken();
            left = new OrExp(left, this.getAndExp());
        }
        return left;
    }

    private BooleanExpression getAndExp() throws SeasarException {
        BooleanExpression left = this.getNotExp();
        while (this._token == 2) {
            this.nextToken();
            left = new AndExp(left, this.getNotExp());
        }
        return left;
    }

    private BooleanExpression getNotExp() throws SeasarException {
        switch (this._token) {
            case 3: {
                this.nextToken();
                BooleanExpression e = this.getSimpleBoolExp();
                return new NotExp(e);
            }
        }
        return this.getSimpleBoolExp();
    }

    private BooleanExpression getSimpleBoolExp() throws SeasarException {
        switch (this._token) {
            case 9: {
                this.nextToken();
                BooleanExpression e = this.getOrExp();
                this.expect(10);
                return e;
            }
            case 35: {
                this.nextToken();
                if (this._token == 38) {
                    this.nextToken();
                    switch (this._token) {
                        case 35: {
                            this.nextToken();
                            return new BooleanExp(true);
                        }
                        case 36: {
                            this.nextToken();
                            return new BooleanExp(false);
                        }
                    }
                } else {
                    return new BooleanExp(true);
                }
            }
            case 36: {
                this.nextToken();
                if (this._token == 38) {
                    this.nextToken();
                    switch (this._token) {
                        case 35: {
                            this.nextToken();
                            return new BooleanExp(false);
                        }
                        case 36: {
                            this.nextToken();
                            return new BooleanExp(true);
                        }
                    }
                    break;
                }
                return new BooleanExp(false);
            }
        }
        Expression targetExp = this.getAddSubExp();
        switch (this._token) {
            case 16: {
                this.nextToken();
                return new EqualExp(targetExp, this.getAddSubExp());
            }
            case 17: {
                this.nextToken();
                return new NotEqualExp(targetExp, this.getAddSubExp());
            }
            case 19: {
                this.nextToken();
                return new GreaterEqualExp(targetExp, this.getAddSubExp());
            }
            case 18: {
                this.nextToken();
                return new GreaterThanExp(targetExp, this.getAddSubExp());
            }
            case 21: {
                this.nextToken();
                return new LessEqualExp(targetExp, this.getAddSubExp());
            }
            case 20: {
                this.nextToken();
                return new LessThanExp(targetExp, this.getAddSubExp());
            }
            case 25: {
                return this.getInExp(targetExp);
            }
            case 26: {
                return this.getBetweenExp(targetExp);
            }
            case 38: {
                this.nextToken();
                switch (this._token) {
                    case 39: {
                        this.nextToken();
                        return new IsNullExp(targetExp);
                    }
                    case 3: {
                        this.nextToken();
                        this.expect(39);
                        return new IsNotNullExp(targetExp);
                    }
                    case 35: {
                        this.nextToken();
                        return new IsTrueExp(targetExp);
                    }
                    case 36: {
                        this.nextToken();
                        return new IsFalseExp(targetExp);
                    }
                }
            }
            case 3: {
                this.nextToken();
                switch (this._token) {
                    case 40: {
                        this.nextToken();
                        return new NotExp(new LikeExp(targetExp, this.getAddSubExp()));
                    }
                    case 26: {
                        return this.getNotBetweenExp(targetExp);
                    }
                    case 25: {
                        return new NotExp(this.getInExp(targetExp));
                    }
                }
            }
            case 40: {
                this.nextToken();
                return new LikeExp(targetExp, this.getAddSubExp());
            }
            case 49: {
                this.nextToken();
                return new MatchExp(targetExp, this.getAddSubExp());
            }
            case 50: {
                this.nextToken();
                return new MatchExp(targetExp, this.getAddSubExp(), true);
            }
            case 64: {
                this.nextToken();
                return new NotExp(new MatchExp(targetExp, this.getAddSubExp()));
            }
            case 65: {
                this.nextToken();
                return new NotExp(new MatchExp(targetExp, this.getAddSubExp(), true));
            }
        }
        throw new SeasarException("ESSR0032", new Object[]{RuleTokenizer.getTokenName(this._token)});
    }

    private BooleanExpression getInExp(Expression targetExp) throws SeasarException {
        this.nextToken();
        this.expect(9);
        ArrayList<Expression> inExpList = new ArrayList<Expression>();
        inExpList.add(this.getAddSubExp());
        while (this._token == 22) {
            this.nextToken();
            inExpList.add(this.getAddSubExp());
        }
        this.expect(10);
        return new InExp(targetExp, NazunaUtil.toExpressionArray(inExpList));
    }

    private BooleanExpression getBetweenExp(Expression targetExp) throws SeasarException {
        this.nextToken();
        Expression fromExp = this.getAddSubExp();
        this.expect(2);
        Expression toExp = this.getAddSubExp();
        return new BetweenExp(targetExp, fromExp, toExp);
    }

    private BooleanExpression getNotBetweenExp(Expression targetExp) throws SeasarException {
        this.nextToken();
        Expression fromExp = this.getAddSubExp();
        this.expect(2);
        Expression toExp = this.getAddSubExp();
        return new NotBetweenExp(targetExp, fromExp, toExp);
    }

    private Expression getAddSubExp() throws SeasarException {
        Expression arg1Exp = this.getMultDivModExp();
        while (this._token == 11 || this._token == 12) {
            int t = this._token;
            this.nextToken();
            arg1Exp = new AddSubExp(arg1Exp, this.getMultDivModExp(), t);
        }
        return arg1Exp;
    }

    private Expression getMultDivModExp() throws SeasarException {
        Expression arg1Exp = this.getConcatenateExp();
        while (this._token == 13 || this._token == 14 || this._token == 15) {
            int t = this._token;
            this.nextToken();
            arg1Exp = new MultDivModExp(arg1Exp, this.getConcatenateExp(), t);
        }
        return arg1Exp;
    }

    private Expression getConcatenateExp() throws SeasarException {
        Expression exp = this.getSimpleExp();
        if (this._token != 43) {
            return exp;
        }
        ArrayList<Expression> exps = new ArrayList<Expression>();
        exps.add(exp);
        while (this._token == 43) {
            this.nextToken();
            exps.add(this.getSimpleExp());
        }
        return new ConcatenateExp(NazunaUtil.toExpressionArray(exps));
    }

    private Expression getSimpleExp() throws SeasarException {
        switch (this._token) {
            case 9: {
                this.nextToken();
                Expression e = this.getAddSubExp();
                this.expect(10);
                return e;
            }
            case 8: {
                return this.getDoubleExp();
            }
            case 7: {
                return this.getLongExp();
            }
            case 6: {
                return this.getIntegerExp();
            }
            case 5: {
                return this.getStringExp();
            }
            case 4: {
                return this.getWordExp();
            }
            case 27: {
                return this.getToTimestampExp();
            }
            case 28: {
                return this.getToStringExp();
            }
            case 29: {
                return this.getToBigDecimalExp();
            }
            case 68: {
                return this.getToDoubleExp();
            }
            case 30: {
                return this.getToLongExp();
            }
            case 31: {
                return this.getToIntegerExp();
            }
            case 48: {
                return this.getToBooleanExp();
            }
            case 34: {
                return this.getNowExp();
            }
            case 39: {
                return this.getNullExp();
            }
            case 59: {
                return this.getSubstringExp();
            }
            case 58: {
                return this.getPositionExp();
            }
            case 37: {
                return this.getCaseExp();
            }
            case 41: {
                return this.getCoalesceExp();
            }
            case 45: {
                return this.getNvlExp();
            }
            case 44: {
                return this.getNullifExp();
            }
            case 46: {
                return this.getTrimExp();
            }
            case 23: {
                return this.getNewExp();
            }
            case 35: {
                this.nextToken();
                return new BooleanExp(true);
            }
            case 36: {
                this.nextToken();
                return new BooleanExp(false);
            }
            case 42: 
            case 66: 
            case 67: 
            case 78: 
            case 79: {
                return this.getExecuteExp(this._token);
            }
            case 77: {
                return this.getExecuteRuletExp();
            }
        }
        throw new SeasarException("ESSR0032", new Object[]{RuleTokenizer.getTokenName(this._token)});
    }

    private Expression getDoubleExp() throws SeasarException {
        DoubleExp e = new DoubleExp(this._tokenizer.getDouble());
        this.nextToken();
        return e;
    }

    private Expression getLongExp() throws SeasarException {
        LongExp e = new LongExp(this._tokenizer.getLong());
        this.nextToken();
        return e;
    }

    private Expression getIntegerExp() throws SeasarException {
        IntegerExp e = new IntegerExp(this._tokenizer.getInteger());
        this.nextToken();
        return e;
    }

    private Expression getStringExp() throws SeasarException {
        String s = this._tokenizer.getString();
        this.nextToken();
        if (this._token == 5) {
            s = s + "'" + this._tokenizer.getString();
            this.nextToken();
        }
        return new StringExp(s);
    }

    private Expression getToTimestampExp() throws SeasarException {
        this.nextToken();
        this.expect(9);
        Expression p1 = this.getSimpleExp();
        Expression p2 = null;
        if (this._token == 22) {
            this.nextToken();
            p2 = this.getStringExp();
        }
        String pattern = null;
        if (p2 != null) {
            pattern = (String)p2.evaluateValue(null);
        }
        this.expect(10);
        return new ToTimestampExp(p1, pattern);
    }

    private Expression getToStringExp() throws SeasarException {
        this.nextToken();
        this.expect(9);
        Expression p1 = this.getAddSubExp();
        Expression p2 = null;
        if (this._token == 22) {
            this.nextToken();
            p2 = this.getStringExp();
        }
        String pattern = null;
        if (p2 != null) {
            pattern = (String)p2.evaluateValue(null);
        }
        this.expect(10);
        return new ToStringExp(p1, pattern);
    }

    private Expression getToBigDecimalExp() throws SeasarException {
        this.nextToken();
        this.expect(9);
        Expression p1 = this.getAddSubExp();
        Expression p2 = null;
        if (this._token == 22) {
            this.nextToken();
            p2 = this.getStringExp();
        }
        String pattern = null;
        if (p2 != null) {
            pattern = (String)p2.evaluateValue(null);
        }
        this.expect(10);
        return new ToBigDecimalExp(p1, pattern);
    }

    private Expression getToDoubleExp() throws SeasarException {
        this.nextToken();
        this.expect(9);
        Expression p1 = this.getAddSubExp();
        Expression p2 = null;
        if (this._token == 22) {
            this.nextToken();
            p2 = this.getStringExp();
        }
        String pattern = null;
        if (p2 != null) {
            pattern = (String)p2.evaluateValue(null);
        }
        this.expect(10);
        return new ToDoubleExp(p1, pattern);
    }

    private Expression getToLongExp() throws SeasarException {
        this.nextToken();
        this.expect(9);
        Expression p1 = this.getAddSubExp();
        Expression p2 = null;
        if (this._token == 22) {
            this.nextToken();
            p2 = this.getStringExp();
        }
        String pattern = null;
        if (p2 != null) {
            pattern = (String)p2.evaluateValue(null);
        }
        this.expect(10);
        return new ToLongExp(p1, pattern);
    }

    private Expression getToIntegerExp() throws SeasarException {
        this.nextToken();
        this.expect(9);
        Expression p1 = this.getAddSubExp();
        Expression p2 = null;
        if (this._token == 22) {
            this.nextToken();
            p2 = this.getStringExp();
        }
        String pattern = null;
        if (p2 != null) {
            pattern = (String)p2.evaluateValue(null);
        }
        this.expect(10);
        return new ToIntegerExp(p1, pattern);
    }

    private Expression getToBooleanExp() throws SeasarException {
        this.nextToken();
        this.expect(9);
        BooleanExpression argExp = this.getOrExp();
        this.expect(10);
        return new ToBooleanExp(argExp);
    }

    private Expression getNowExp() throws SeasarException {
        this.nextToken();
        this.expect(9);
        this.expect(10);
        return new NowExp();
    }

    private Expression getNullExp() throws SeasarException {
        this.nextToken();
        return new NullExp();
    }

    private Expression getSubstringExp() throws SeasarException {
        this.nextToken();
        this.expect(9);
        ArrayList<Expression> argExps = new ArrayList<Expression>();
        Expression arg1Exp = this.getAddSubExp();
        argExps.add(arg1Exp);
        this.expect(24);
        Expression fromExp = this.getAddSubExp();
        argExps.add(fromExp);
        Expression forExp = null;
        if (this._token == 32) {
            this.nextToken();
            forExp = this.getAddSubExp();
            argExps.add(forExp);
        }
        this.expect(10);
        return new MethodExp("org.seasar.util.StringUtil", "substr", NazunaUtil.toExpressionArray(argExps));
    }

    private Expression getPositionExp() throws SeasarException {
        this.nextToken();
        this.expect(9);
        Expression argExp = this.getAddSubExp();
        this.expect(25);
        Expression strExp = this.getAddSubExp();
        this.expect(10);
        ArrayList<Expression> argExps = new ArrayList<Expression>();
        argExps.add(strExp);
        argExps.add(argExp);
        return new MethodExp("org.seasar.util.StringUtil", "strpos", NazunaUtil.toExpressionArray(argExps));
    }

    private Expression getCaseExp() throws SeasarException {
        this.nextToken();
        ArrayList<BooleanExpression> boolExpList = new ArrayList<BooleanExpression>();
        ArrayList<Expression> expList = new ArrayList<Expression>();
        if (this._token == 60) {
            while (this._token == 60) {
                this.nextToken();
                boolExpList.add(this.getOrExp());
                this.expect(61);
                expList.add(this.getAddSubExp());
            }
        } else {
            Expression targetExp = this.getAddSubExp();
            while (this._token == 60) {
                this.nextToken();
                boolExpList.add(new EqualExp(targetExp, this.getAddSubExp()));
                this.expect(61);
                expList.add(this.getAddSubExp());
            }
        }
        if (this._token == 62) {
            this.nextToken();
            boolExpList.add(new BooleanExp(true));
            expList.add(this.getAddSubExp());
        }
        this.expect(63);
        BooleanExpression[] boolExps = NazunaUtil.toBooleanExpressionArray(boolExpList);
        Expression[] exps = NazunaUtil.toExpressionArray(expList);
        return new CaseExp(boolExps, exps);
    }

    private Expression getCoalesceExp() throws SeasarException {
        this.nextToken();
        this.expect(9);
        ArrayList<Expression> expList = new ArrayList<Expression>();
        expList.add(this.getAddSubExp());
        while (this._token == 22) {
            this.nextToken();
            expList.add(this.getAddSubExp());
        }
        this.expect(10);
        return new CoalesceExp(NazunaUtil.toExpressionArray(expList));
    }

    private Expression getNvlExp() throws SeasarException {
        this.nextToken();
        this.expect(9);
        Expression arg1Exp = this.getAddSubExp();
        this.expect(22);
        Expression arg2Exp = this.getAddSubExp();
        this.expect(10);
        return new NvlExp(arg1Exp, arg2Exp);
    }

    private Expression getNullifExp() throws SeasarException {
        this.nextToken();
        this.expect(9);
        Expression arg1Exp = this.getAddSubExp();
        this.expect(22);
        Expression arg2Exp = this.getAddSubExp();
        this.expect(10);
        return new NullifExp(arg1Exp, arg2Exp);
    }

    private Expression getTrimExp() throws SeasarException {
        this.nextToken();
        this.expect(9);
        String methodName = "btrim";
        switch (this._token) {
            case 55: {
                methodName = "ltrim";
                this.nextToken();
                break;
            }
            case 56: {
                methodName = "rtrim";
                this.nextToken();
                break;
            }
            case 57: {
                this.nextToken();
            }
        }
        Expression trimStrExp = new StringExp(" ");
        if (this._token != 24) {
            trimStrExp = this.getAddSubExp();
        }
        this.expect(24);
        Expression strExp = this.getAddSubExp();
        this.expect(10);
        ArrayList<Expression> argExps = new ArrayList<Expression>();
        argExps.add(strExp);
        argExps.add(trimStrExp);
        return new MethodExp("org.seasar.util.StringUtil", methodName, NazunaUtil.toExpressionArray(argExps));
    }

    private Expression getWordExp() throws SeasarException {
        String s = this._tokenizer.getString();
        this.nextToken();
        if (this._token != 9) {
            return this.getVariableExp(s);
        }
        return this.getMethodExp(s);
    }

    private Expression getVariableExp(String name) throws SeasarException {
        if (this._token == 51) {
            this.nextToken();
            int index = this._tokenizer.getInteger();
            this.nextToken();
            this.expect(52);
            if (this._token == 33) {
                this.nextToken();
                return new SetArrayVariableExp(name, index, this.getAddSubExp());
            }
            return new GetArrayVariableExp(name, index);
        }
        if (this._token == 33) {
            this.nextToken();
            return new SetVariableExp(name, this.getAddSubExp());
        }
        return new GetVariableExp(name);
    }

    private Expression getMethodExp(String s) throws SeasarException {
        this.nextToken();
        String targetName = null;
        String methodName = null;
        AliasConfig aliasConfig = Nazuna.getNazunaConfig().resolveAlias(s);
        if (aliasConfig != null) {
            targetName = aliasConfig.getClassName();
            methodName = aliasConfig.getMethodName();
        } else {
            int pos = s.lastIndexOf(46);
            targetName = s.substring(0, pos);
            methodName = s.substring(pos + 1);
        }
        ArrayList<Expression> argExps = new ArrayList<Expression>();
        if (this._token != 10) {
            argExps.add(this.getAddSubExp());
            while (this._token == 22) {
                this.nextToken();
                argExps.add(this.getAddSubExp());
            }
        }
        this.expect(10);
        return new MethodExp(targetName, methodName, NazunaUtil.toExpressionArray(argExps));
    }

    private Expression getNewExp() throws SeasarException {
        this.nextToken();
        String className = this._tokenizer.getString();
        this.nextToken();
        if (this._token == 9) {
            this.nextToken();
            ArrayList<Expression> argExpList = new ArrayList<Expression>();
            if (this._token != 10) {
                argExpList.add(this.getAddSubExp());
                while (this._token == 22) {
                    this.nextToken();
                    argExpList.add(this.getAddSubExp());
                }
            }
            this.expect(10);
            return new NewExp(Reflector.getClass(className), NazunaUtil.toExpressionArray(argExpList));
        }
        this.expect(51);
        int arraySize = 0;
        if (this._token == 6) {
            arraySize = this._tokenizer.getInteger();
            this.nextToken();
        }
        this.expect(52);
        ArrayList<Expression> argExpList = new ArrayList<Expression>();
        if (this._token == 53) {
            this.nextToken();
            argExpList.add(this.getAddSubExp());
            while (this._token == 22) {
                this.nextToken();
                argExpList.add(this.getAddSubExp());
            }
            this.expect(54);
            if (arraySize < argExpList.size()) {
                arraySize = argExpList.size();
            }
        }
        return new NewArrayExp(Reflector.getClass(className), arraySize, NazunaUtil.toExpressionArray(argExpList));
    }

    private Expression getExecuteExp(int methodType) throws SeasarException {
        this.nextToken();
        this.expect(9);
        Expression pathExp = this.getAddSubExp();
        EMap parameterExps = new EMap();
        while (this._token == 22) {
            this.nextToken();
            String name = this._tokenizer.getString();
            this.nextToken();
            this.expect(33);
            parameterExps.put(name, this.getAddSubExp());
        }
        this.expect(10);
        switch (methodType) {
            case 42: {
                return new ExecuteExp(pathExp, parameterExps);
            }
            case 66: {
                return new ExecuteQueryExp(pathExp, parameterExps);
            }
            case 78: {
                return new ExecuteRSQueryExp(pathExp, parameterExps);
            }
            case 79: {
                return new ExecuteSingleQueryExp(pathExp, parameterExps);
            }
            case 67: {
                return new ExecuteUpdateExp(pathExp, parameterExps);
            }
        }
        throw new SeasarException("ESSR0032", new Object[]{RuleTokenizer.getTokenName(this._token)});
    }

    private Expression getExecuteRuletExp() throws SeasarException {
        this.nextToken();
        this.expect(9);
        Expression nameExp = this.getAddSubExp();
        EArrayList argExpList = new EArrayList();
        while (this._token == 22) {
            this.nextToken();
            argExpList.add(this.getAddSubExp());
        }
        this.expect(10);
        Expression[] argExps = argExpList.toArray((T[])new Expression[argExpList.size()]);
        return new ExecuteRuletExp(nameExp, argExps);
    }

    private void nextToken() throws SeasarException {
        this._token = this._tokenizer.nextToken();
    }

    public void expect(int t) throws SeasarException {
        RuleTokenizer.assertToken(t, this._token);
        this.nextToken();
    }
}

