/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.seasar.log.Logger;
import org.seasar.nazuna.Arg;
import org.seasar.nazuna.RuleBase;
import org.seasar.nazuna.RuleContext;
import org.seasar.nazuna.Var;
import org.seasar.util.Assertion;
import org.seasar.util.LineUtil;
import org.seasar.util.SeasarException;

public final class RuleContextImpl
implements RuleContext {
    private static Logger _logger = Logger.getLogger(class$org$seasar$nazuna$RuleContextImpl == null ? (class$org$seasar$nazuna$RuleContextImpl = RuleContextImpl.class$("org.seasar.nazuna.RuleContextImpl")) : class$org$seasar$nazuna$RuleContextImpl);
    private RuleBase _owner;
    private Map _args;
    private Map _vars;
    private Object _returnValue;
    private boolean _returned = false;
    private Throwable _throwable;
    private boolean _throwed = false;
    private String _throwedLocation;
    private String _breakedLabel;
    private String _continuedLabel;
    private boolean _whenBreaked = false;
    private StringBuffer _textBuf = new StringBuffer(255);
    private List _bindVariables = new ArrayList();
    private boolean _whereEnabled = false;
    static /* synthetic */ Class class$org$seasar$nazuna$RuleContextImpl;

    public RuleContextImpl(RuleBase owner, Map parameters) throws SeasarException {
        Assertion.assertNotNull("owner", owner);
        this._owner = owner;
        this._args = owner.createArgs(parameters);
        this._vars = owner.createVars();
    }

    public RuleBase getOwner() {
        return this._owner;
    }

    public final Object getValue(String name) throws SeasarException {
        Var var = this.getVar(name);
        if (var != null) {
            return var.getValue();
        }
        Arg arg = this.getArg(name);
        if (arg != null) {
            return arg.getValue();
        }
        if (this._owner.containsConst(name)) {
            return this._owner.getConst(name);
        }
        throw new SeasarException("ESSR0001", new Object[]{name});
    }

    public final Arg getArg(String name) {
        return (Arg)this._args.get(name);
    }

    public final Var getVar(String name) {
        return (Var)this._vars.get(name);
    }

    public final void setValue(String name, Object value) throws SeasarException {
        Var var = this.getVar(name);
        if (var != null) {
            var.setValue(value);
        } else {
            Arg arg = this.getArg(name);
            if (arg != null) {
                arg.setValue(value);
            } else {
                if (this._owner.containsConst(name)) {
                    throw new SeasarException("ESSR0035");
                }
                throw new SeasarException("ESSR0001", new Object[]{name});
            }
        }
    }

    public final Object getReturnValue() {
        return this._returnValue;
    }

    public final void setReturnValue(Object returnValue) throws SeasarException {
        this._owner.getOutputType().validate(returnValue);
        this._returnValue = returnValue;
        this._returned = true;
    }

    public final boolean isReturned() {
        return this._returned;
    }

    public final void clearReturned() {
        this._returned = false;
    }

    public final void throwSeasarExcepton() throws SeasarException, RuntimeException {
        SeasarException ex = new SeasarException("ESSR0347", new Object[]{this._throwedLocation, this._throwable}, this._throwable);
        _logger.log(ex);
        if (this._throwable instanceof RuntimeException) {
            throw (RuntimeException)this._throwable;
        }
        if (this._throwable instanceof Error) {
            throw (Error)this._throwable;
        }
        throw SeasarException.convertSeasarException(this._throwable);
    }

    public final void setThrowable(Throwable throwable, String location) {
        this._throwable = throwable;
        this._throwedLocation = location;
        this._throwed = true;
    }

    public final boolean isThrowed() {
        return this._throwed;
    }

    public final void clearThrowed() {
        this._throwed = false;
    }

    public final boolean isBreaked() {
        return this._breakedLabel != null;
    }

    public final boolean isBreaked(String label) {
        return label.equals(this._breakedLabel);
    }

    public final void setBreak(String forLabel) throws SeasarException {
        this._breakedLabel = forLabel;
    }

    public final boolean isContinued() {
        return this._continuedLabel != null;
    }

    public final boolean isContinued(String label) {
        return label.equals(this._continuedLabel);
    }

    public final void clearForState() {
        this._breakedLabel = null;
        this._continuedLabel = null;
    }

    public final void setContinue(String forLabel) throws SeasarException {
        this._continuedLabel = forLabel;
    }

    public final boolean isWhenBreaked() {
        return this._whenBreaked;
    }

    public final void clearWhenBreaked() {
        this._whenBreaked = false;
    }

    public final void breakWhen() {
        this._whenBreaked = true;
    }

    public String getText() {
        return this._textBuf.toString();
    }

    public void addText(String text) {
        this._textBuf.append(text);
    }

    public void addLineSeparaterText() {
        this._textBuf.append(LineUtil.LINE_SP);
    }

    public boolean isEmptyText() {
        return this._textBuf.length() == 0;
    }

    public void addBindVariable(Object bindVariable) {
        this._bindVariables.add(bindVariable);
    }

    public void addBindVariables(List bindVariables) {
        this._bindVariables.addAll(bindVariables);
    }

    public List getBindVariables() {
        return this._bindVariables;
    }

    public boolean isWhereEnabled() {
        return this._whereEnabled;
    }

    public void enableWhere() {
        this._whereEnabled = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

