/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.seasar.nazuna.ConstAware;
import org.seasar.nazuna.InputType;
import org.seasar.nazuna.LocalType;
import org.seasar.nazuna.NazunaTransAttribute;
import org.seasar.nazuna.OutputType;
import org.seasar.nazuna.RuleStatement;
import org.seasar.nazuna.RuleStatementContainer;
import org.seasar.nazuna.Var;
import org.seasar.util.SMap;
import org.seasar.util.SeasarException;

public class RuleBase
implements RuleStatementContainer,
ConstAware {
    protected RuleStatement[] _ruleStatements = RuleStatement.EMPTY_ARRAY;
    private List _tempRuleStatementList = new ArrayList();
    private Map _consts = new SMap();
    private long _lastModified;
    private NazunaTransAttribute _transAttribute = NazunaTransAttribute.SUPPORTS;
    private InputType _inputType;
    private OutputType _outputType;
    private LocalType _localType;

    public final RuleStatement[] getRuleStatements() {
        return this._ruleStatements;
    }

    public final void addRuleStatement(RuleStatement ruleStatement) {
        this._tempRuleStatementList.add(ruleStatement);
    }

    public final void addRuleStatementDone() {
        this._ruleStatements = this._tempRuleStatementList.toArray(new RuleStatement[this._tempRuleStatementList.size()]);
        this._tempRuleStatementList.clear();
        this._tempRuleStatementList = null;
    }

    public final void addConst(String name, Object value) {
        this._consts.put(name, value);
    }

    public final Object getConst(String name) {
        return this._consts.get(name);
    }

    public final boolean containsConst(String name) {
        return this._consts.containsKey(name);
    }

    public final Map getConsts() {
        return this._consts;
    }

    public final void addConsts(Map consts) {
        this._consts.putAll(consts);
    }

    public final long getLastModified() {
        return this._lastModified;
    }

    final void setLastModified(long lastModified) {
        this._lastModified = lastModified;
    }

    public final NazunaTransAttribute getTransAttribute() {
        return this._transAttribute;
    }

    public final void setTransAttribute(NazunaTransAttribute transAttribute) {
        this._transAttribute = transAttribute;
    }

    public final InputType getInputType() {
        return this._inputType;
    }

    public final void setInputType(InputType inputType) {
        this._inputType = inputType;
    }

    public Map createArgs(Map parameters) throws SeasarException {
        if (this._inputType == null) {
            return new SMap(1);
        }
        return this._inputType.createArgs(parameters);
    }

    public boolean containsArgType(String name) {
        if (this._inputType == null) {
            return false;
        }
        return this._inputType.containsArgType(name);
    }

    public final OutputType getOutputType() {
        return this._outputType;
    }

    public final void setOutputType(OutputType outputType) {
        this._outputType = outputType;
    }

    public final LocalType getLocalType() {
        return this._localType;
    }

    public final void setLocalType(LocalType localType) {
        this._localType = localType;
    }

    public final Map createVars() throws SeasarException {
        Map ret = new SMap(4);
        if (this._localType != null) {
            ret = this._localType.createVars();
        }
        ret.put(Var.OUT.getName(), Var.OUT);
        return ret;
    }
}

