/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.List;
import java.util.Map;
import org.seasar.log.Logger;
import org.seasar.nazuna.NazunaLocation;
import org.seasar.nazuna.NazunaURL;
import org.seasar.nazuna.NzRecordSet;
import org.seasar.util.Assertion;
import org.seasar.util.EArrayList;
import org.seasar.util.SeasarException;
import org.seasar.util.ThrowableUtil;

public final class RemoteLocation
implements NazunaLocation {
    private String _name;
    private List _urls = new EArrayList();
    private int _urlIndex = 0;

    public RemoteLocation(String name) {
        Assertion.assertNotNull("name", name);
        this._name = name;
    }

    public final String getName() {
        return this._name;
    }

    public final void addURL(NazunaURL url) {
        this._urls.add(url);
    }

    public final int getURLSize() {
        return this._urls.size();
    }

    public final NazunaURL getURL(int index) {
        return (NazunaURL)this._urls.get(index);
    }

    public final Object executeRulet(String className, Object[] args) throws SeasarException {
        NazunaURL url = this.getURL(this._urlIndex);
        Object ret = null;
        try {
            ret = url.executeRulet(className, args);
        }
        catch (UndeclaredThrowableException ex) {
            return this.executeRuletFailover(url, ex, className, args);
        }
        catch (SeasarException ex) {
            if (ex.getMessageCode().equals("ESSR0040")) {
                return this.executeRuletFailoverIOException(url, ex, className, args);
            }
            throw ex;
        }
        this._urlIndex = (this._urlIndex + 1) % this._urls.size();
        return ret;
    }

    public final Object execute(String className, Map parameters) throws SeasarException {
        NazunaURL url = this.getURL(this._urlIndex);
        Object ret = null;
        try {
            ret = url.execute(className, parameters);
        }
        catch (UndeclaredThrowableException ex) {
            return this.executeFailover(url, ex, className, parameters);
        }
        catch (SeasarException ex) {
            if (ex.getMessageCode().equals("ESSR0040")) {
                return this.executeFailoverIOException(url, ex, className, parameters);
            }
            throw ex;
        }
        this._urlIndex = (this._urlIndex + 1) % this._urls.size();
        return ret;
    }

    public final Object execute(String className, Object[] args) throws SeasarException {
        NazunaURL url = this.getURL(this._urlIndex);
        Object ret = null;
        try {
            ret = url.execute(className, args);
        }
        catch (UndeclaredThrowableException ex) {
            return this.executeFailover(url, ex, className, args);
        }
        catch (SeasarException ex) {
            if (ex.getMessageCode().equals("ESSR0040")) {
                return this.executeFailoverIOException(url, ex, className, args);
            }
            throw ex;
        }
        this._urlIndex = (this._urlIndex + 1) % this._urls.size();
        return ret;
    }

    public final List executeQuery(String className, Map parameters) throws SeasarException {
        NazunaURL url = this.getURL(this._urlIndex);
        List ret = null;
        try {
            ret = url.executeQuery(className, parameters);
        }
        catch (UndeclaredThrowableException ex) {
            return this.executeQueryFailover(url, ex, className, parameters);
        }
        catch (SeasarException ex) {
            if (ex.getMessageCode().equals("ESSR0040")) {
                return this.executeQueryFailoverIOException(url, ex, className, parameters);
            }
            throw ex;
        }
        this._urlIndex = (this._urlIndex + 1) % this._urls.size();
        return ret;
    }

    public final List executeQuery(String className, Object[] args) throws SeasarException {
        NazunaURL url = this.getURL(this._urlIndex);
        List ret = null;
        try {
            ret = url.executeQuery(className, args);
        }
        catch (UndeclaredThrowableException ex) {
            return this.executeQueryFailover(url, ex, className, args);
        }
        catch (SeasarException ex) {
            if (ex.getMessageCode().equals("ESSR0040")) {
                return this.executeQueryFailoverIOException(url, ex, className, args);
            }
            throw ex;
        }
        this._urlIndex = (this._urlIndex + 1) % this._urls.size();
        return ret;
    }

    public final NzRecordSet executeRSQuery(String className, Map parameters) throws SeasarException {
        NazunaURL url = this.getURL(this._urlIndex);
        NzRecordSet ret = null;
        try {
            ret = url.executeRSQuery(className, parameters);
        }
        catch (UndeclaredThrowableException ex) {
            return this.executeRSQueryFailover(url, ex, className, parameters);
        }
        catch (SeasarException ex) {
            if (ex.getMessageCode().equals("ESSR0040")) {
                return this.executeRSQueryFailoverIOException(url, ex, className, parameters);
            }
            throw ex;
        }
        this._urlIndex = (this._urlIndex + 1) % this._urls.size();
        return ret;
    }

    public final NzRecordSet executeRSQuery(String className, Object[] args) throws SeasarException {
        NazunaURL url = this.getURL(this._urlIndex);
        NzRecordSet ret = null;
        try {
            ret = url.executeRSQuery(className, args);
        }
        catch (UndeclaredThrowableException ex) {
            return this.executeRSQueryFailover(url, ex, className, args);
        }
        catch (SeasarException ex) {
            if (ex.getMessageCode().equals("ESSR0040")) {
                return this.executeRSQueryFailoverIOException(url, ex, className, args);
            }
            throw ex;
        }
        this._urlIndex = (this._urlIndex + 1) % this._urls.size();
        return ret;
    }

    public final Object executeSingleQuery(String className, Map parameters) throws SeasarException {
        NazunaURL url = this.getURL(this._urlIndex);
        Object ret = null;
        try {
            ret = url.executeSingleQuery(className, parameters);
        }
        catch (UndeclaredThrowableException ex) {
            return this.executeSingleQueryFailover(url, ex, className, parameters);
        }
        catch (SeasarException ex) {
            if (ex.getMessageCode().equals("ESSR0040")) {
                return this.executeSingleQueryFailoverIOException(url, ex, className, parameters);
            }
            throw ex;
        }
        this._urlIndex = (this._urlIndex + 1) % this._urls.size();
        return ret;
    }

    public final Object executeSingleQuery(String className, Object[] args) throws SeasarException {
        NazunaURL url = this.getURL(this._urlIndex);
        Object ret = null;
        try {
            ret = url.executeSingleQuery(className, args);
        }
        catch (UndeclaredThrowableException ex) {
            return this.executeSingleQueryFailover(url, ex, className, args);
        }
        catch (SeasarException ex) {
            if (ex.getMessageCode().equals("ESSR0040")) {
                return this.executeSingleQueryFailoverIOException(url, ex, className, args);
            }
            throw ex;
        }
        this._urlIndex = (this._urlIndex + 1) % this._urls.size();
        return ret;
    }

    public final int executeUpdate(String className, Map parameters) throws SeasarException {
        NazunaURL url = this.getURL(this._urlIndex);
        int ret = -1;
        try {
            ret = url.executeUpdate(className, parameters);
        }
        catch (UndeclaredThrowableException ex) {
            return this.executeUpdateFailover(url, ex, className, parameters);
        }
        catch (SeasarException ex) {
            if (ex.getMessageCode().equals("ESSR0040")) {
                return this.executeUpdateFailoverIOException(url, ex, className, parameters);
            }
            throw ex;
        }
        this._urlIndex = (this._urlIndex + 1) % this._urls.size();
        return ret;
    }

    public final int executeUpdate(String className, Object[] args) throws SeasarException {
        NazunaURL url = this.getURL(this._urlIndex);
        int ret = -1;
        try {
            ret = url.executeUpdate(className, args);
        }
        catch (UndeclaredThrowableException ex) {
            return this.executeUpdateFailover(url, ex, className, args);
        }
        catch (SeasarException ex) {
            if (ex.getMessageCode().equals("ESSR0040")) {
                return this.executeUpdateFailoverIOException(url, ex, className, args);
            }
            throw ex;
        }
        this._urlIndex = (this._urlIndex + 1) % this._urls.size();
        return ret;
    }

    private static boolean isFailoverThrowable(Throwable t) {
        if (!(t instanceof RemoteException)) {
            return false;
        }
        if (t instanceof UnmarshalException) {
            String s = ThrowableUtil.getStackTraceString(t);
            return s.indexOf("SocketException") > 0;
        }
        return t instanceof ConnectException || t instanceof NoSuchObjectException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeRuletFailover(NazunaURL url, UndeclaredThrowableException ex, String className, Object[] args) throws SeasarException {
        Throwable t = ThrowableUtil.getCause(ex);
        List list = this._urls;
        synchronized (list) {
            if (this._urls.size() > 1 && this._urls.indexOf(url) >= 0 && RemoteLocation.isFailoverThrowable(t)) {
                this.fail(url, t);
                return this.executeRulet(className, args);
            }
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw SeasarException.convertSeasarException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeRuletFailoverIOException(NazunaURL url, SeasarException ex, String className, Object[] args) throws SeasarException {
        List list = this._urls;
        synchronized (list) {
            if (this._urls.size() > 1 && this._urls.indexOf(url) >= 0) {
                this.fail(url, ex);
                return this.executeRulet(className, args);
            }
        }
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeFailover(NazunaURL url, UndeclaredThrowableException ex, String className, Map parameters) throws SeasarException {
        Throwable t = ThrowableUtil.getCause(ex);
        List list = this._urls;
        synchronized (list) {
            if (this._urls.size() > 1 && this._urls.indexOf(url) >= 0 && RemoteLocation.isFailoverThrowable(t)) {
                this.fail(url, t);
                return this.execute(className, parameters);
            }
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw SeasarException.convertSeasarException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeFailoverIOException(NazunaURL url, SeasarException ex, String className, Map parameters) throws SeasarException {
        List list = this._urls;
        synchronized (list) {
            if (this._urls.size() > 1 && this._urls.indexOf(url) >= 0) {
                this.fail(url, ex);
                return this.execute(className, parameters);
            }
        }
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeFailover(NazunaURL url, UndeclaredThrowableException ex, String className, Object[] args) throws SeasarException {
        Throwable t = ThrowableUtil.getCause(ex);
        List list = this._urls;
        synchronized (list) {
            if (this._urls.size() > 1 && this._urls.indexOf(url) >= 0 && RemoteLocation.isFailoverThrowable(t)) {
                this.fail(url, t);
                return this.execute(className, args);
            }
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw SeasarException.convertSeasarException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeFailoverIOException(NazunaURL url, SeasarException ex, String className, Object[] args) throws SeasarException {
        List list = this._urls;
        synchronized (list) {
            if (this._urls.size() > 1 && this._urls.indexOf(url) >= 0) {
                this.fail(url, ex);
                return this.execute(className, args);
            }
        }
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List executeQueryFailover(NazunaURL url, UndeclaredThrowableException ex, String className, Map parameters) throws SeasarException {
        Throwable t = ThrowableUtil.getCause(ex);
        List list = this._urls;
        synchronized (list) {
            if (this._urls.size() > 1 && this._urls.indexOf(url) >= 0 && RemoteLocation.isFailoverThrowable(t)) {
                this.fail(url, t);
                return this.executeQuery(className, parameters);
            }
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw SeasarException.convertSeasarException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List executeQueryFailoverIOException(NazunaURL url, SeasarException ex, String className, Map parameters) throws SeasarException {
        List list = this._urls;
        synchronized (list) {
            if (this._urls.size() > 1 && this._urls.indexOf(url) >= 0) {
                this.fail(url, ex);
                return this.executeQuery(className, parameters);
            }
        }
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List executeQueryFailover(NazunaURL url, UndeclaredThrowableException ex, String className, Object[] args) throws SeasarException {
        Throwable t = ThrowableUtil.getCause(ex);
        List list = this._urls;
        synchronized (list) {
            if (this._urls.size() > 1 && this._urls.indexOf(url) >= 0 && RemoteLocation.isFailoverThrowable(t)) {
                this.fail(url, t);
                return this.executeQuery(className, args);
            }
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw SeasarException.convertSeasarException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List executeQueryFailoverIOException(NazunaURL url, SeasarException ex, String className, Object[] args) throws SeasarException {
        List list = this._urls;
        synchronized (list) {
            if (this._urls.size() > 1 && this._urls.indexOf(url) >= 0) {
                this.fail(url, ex);
                return this.executeQuery(className, args);
            }
        }
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NzRecordSet executeRSQueryFailover(NazunaURL url, UndeclaredThrowableException ex, String className, Map parameters) throws SeasarException {
        Throwable t = ThrowableUtil.getCause(ex);
        List list = this._urls;
        synchronized (list) {
            if (this._urls.size() > 1 && this._urls.indexOf(url) >= 0 && RemoteLocation.isFailoverThrowable(t)) {
                this.fail(url, t);
                return this.executeRSQuery(className, parameters);
            }
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw SeasarException.convertSeasarException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NzRecordSet executeRSQueryFailoverIOException(NazunaURL url, SeasarException ex, String className, Map parameters) throws SeasarException {
        List list = this._urls;
        synchronized (list) {
            if (this._urls.size() > 1 && this._urls.indexOf(url) >= 0) {
                this.fail(url, ex);
                return this.executeRSQuery(className, parameters);
            }
        }
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NzRecordSet executeRSQueryFailover(NazunaURL url, UndeclaredThrowableException ex, String className, Object[] args) throws SeasarException {
        Throwable t = ThrowableUtil.getCause(ex);
        List list = this._urls;
        synchronized (list) {
            if (this._urls.size() > 1 && this._urls.indexOf(url) >= 0 && RemoteLocation.isFailoverThrowable(t)) {
                this.fail(url, t);
                return this.executeRSQuery(className, args);
            }
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw SeasarException.convertSeasarException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NzRecordSet executeRSQueryFailoverIOException(NazunaURL url, SeasarException ex, String className, Object[] args) throws SeasarException {
        List list = this._urls;
        synchronized (list) {
            if (this._urls.size() > 1 && this._urls.indexOf(url) >= 0) {
                this.fail(url, ex);
                return this.executeRSQuery(className, args);
            }
        }
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeSingleQueryFailover(NazunaURL url, UndeclaredThrowableException ex, String className, Map parameters) throws SeasarException {
        Throwable t = ThrowableUtil.getCause(ex);
        List list = this._urls;
        synchronized (list) {
            if (this._urls.size() > 1 && this._urls.indexOf(url) >= 0 && RemoteLocation.isFailoverThrowable(t)) {
                this.fail(url, t);
                return this.executeSingleQuery(className, parameters);
            }
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw SeasarException.convertSeasarException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeSingleQueryFailoverIOException(NazunaURL url, SeasarException ex, String className, Map parameters) throws SeasarException {
        List list = this._urls;
        synchronized (list) {
            if (this._urls.size() > 1 && this._urls.indexOf(url) >= 0) {
                this.fail(url, ex);
                return this.executeSingleQuery(className, parameters);
            }
        }
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeSingleQueryFailover(NazunaURL url, UndeclaredThrowableException ex, String className, Object[] args) throws SeasarException {
        Throwable t = ThrowableUtil.getCause(ex);
        List list = this._urls;
        synchronized (list) {
            if (this._urls.size() > 1 && this._urls.indexOf(url) >= 0 && RemoteLocation.isFailoverThrowable(t)) {
                this.fail(url, t);
                return this.executeSingleQuery(className, args);
            }
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw SeasarException.convertSeasarException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeSingleQueryFailoverIOException(NazunaURL url, SeasarException ex, String className, Object[] args) throws SeasarException {
        List list = this._urls;
        synchronized (list) {
            if (this._urls.size() > 1 && this._urls.indexOf(url) >= 0) {
                this.fail(url, ex);
                return this.executeSingleQuery(className, args);
            }
        }
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdateFailover(NazunaURL url, UndeclaredThrowableException ex, String className, Map parameters) throws SeasarException {
        Throwable t = ThrowableUtil.getCause(ex);
        List list = this._urls;
        synchronized (list) {
            if (this._urls.size() > 1 && this._urls.indexOf(url) >= 0 && RemoteLocation.isFailoverThrowable(t)) {
                this.fail(url, t);
                return this.executeUpdate(className, parameters);
            }
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw SeasarException.convertSeasarException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdateFailoverIOException(NazunaURL url, SeasarException ex, String className, Map parameters) throws SeasarException {
        List list = this._urls;
        synchronized (list) {
            if (this._urls.size() > 1 && this._urls.indexOf(url) >= 0) {
                this.fail(url, ex);
                return this.executeUpdate(className, parameters);
            }
        }
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdateFailover(NazunaURL url, UndeclaredThrowableException ex, String className, Object[] args) throws SeasarException {
        Throwable t = ThrowableUtil.getCause(ex);
        List list = this._urls;
        synchronized (list) {
            if (this._urls.size() > 1 && this._urls.indexOf(url) >= 0 && RemoteLocation.isFailoverThrowable(t)) {
                this.fail(url, t);
                return this.executeUpdate(className, args);
            }
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw SeasarException.convertSeasarException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdateFailoverIOException(NazunaURL url, SeasarException ex, String className, Object[] args) throws SeasarException {
        List list = this._urls;
        synchronized (list) {
            if (this._urls.size() > 1 && this._urls.indexOf(url) >= 0) {
                this.fail(url, ex);
                return this.executeUpdate(className, args);
            }
        }
        throw ex;
    }

    private void fail(NazunaURL url, Throwable t) throws SeasarException {
        Logger.getLogger(this.getClass()).error(t);
        Logger.getLogger(this.getClass()).log("WSSR0006", new Object[]{url.getSpec()});
        this._urls.remove(this._urlIndex);
        this._urlIndex = 0;
    }
}

