/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.util.Map;
import org.seasar.log.Logger;
import org.seasar.nazuna.ArgType;
import org.seasar.nazuna.AssertTag;
import org.seasar.nazuna.BooleanExpression;
import org.seasar.nazuna.BreakTag;
import org.seasar.nazuna.CaseTag;
import org.seasar.nazuna.ConstAware;
import org.seasar.nazuna.ContinueTag;
import org.seasar.nazuna.ElseTag;
import org.seasar.nazuna.ElseTagAware;
import org.seasar.nazuna.Expression;
import org.seasar.nazuna.ForTag;
import org.seasar.nazuna.InputType;
import org.seasar.nazuna.LocalType;
import org.seasar.nazuna.NazunaUtil;
import org.seasar.nazuna.OutputType;
import org.seasar.nazuna.ReturnTag;
import org.seasar.nazuna.RuleBase;
import org.seasar.nazuna.RuleParser;
import org.seasar.nazuna.RuleStatementContainer;
import org.seasar.nazuna.StmtTag;
import org.seasar.nazuna.TextTag;
import org.seasar.nazuna.ThrowTag;
import org.seasar.nazuna.ValidateTag;
import org.seasar.nazuna.VarType;
import org.seasar.nazuna.WhenTag;
import org.seasar.nazuna.WhenTagAware;
import org.seasar.util.Assertion;
import org.seasar.util.ElementHandler;
import org.seasar.util.Reflector;
import org.seasar.util.SeasarException;
import org.seasar.util.StringUtil;
import org.seasar.util.XMLHandler;
import org.seasar.util.XMLHandlerRule;
import org.xml.sax.Attributes;

public class NazunaXMLHandlerRule
extends XMLHandlerRule {
    static /* synthetic */ Class class$org$seasar$nazuna$RuleBase;

    public NazunaXMLHandlerRule() {
        this.addElementHandler("stmt", new ElementHandler(){

            public void end(XMLHandler xmlHandler, String body) {
                try {
                    RuleStatementContainer container = (RuleStatementContainer)xmlHandler.peek();
                    Expression exp = new RuleParser(body).parseExpression();
                    StmtTag stmtTag = new StmtTag(container, xmlHandler.getLocationDetailPath(), exp);
                    container.addRuleStatement(stmtTag);
                }
                catch (SeasarException ex) {
                    ex.convertSeasarRuntimeException();
                }
            }
        });
        this.addElementHandler("return", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                RuleBase ruleBase = (RuleBase)xmlHandler.peek(class$org$seasar$nazuna$RuleBase == null ? (class$org$seasar$nazuna$RuleBase = NazunaXMLHandlerRule.class$("org.seasar.nazuna.RuleBase")) : class$org$seasar$nazuna$RuleBase);
                Assertion.assertFound("output", ruleBase.getOutputType());
                RuleStatementContainer container = (RuleStatementContainer)xmlHandler.peek();
                ReturnTag returnTag = new ReturnTag(container, xmlHandler.getLocationDetailPath());
                container.addRuleStatement(returnTag);
                xmlHandler.push(returnTag);
            }

            public void end(XMLHandler xmlHandler, String body) {
                try {
                    ReturnTag returnTag = (ReturnTag)xmlHandler.pop();
                    Expression exp = new RuleParser(body).parseExpression();
                    returnTag.setExpression(exp);
                }
                catch (SeasarException ex) {
                    ex.convertSeasarRuntimeException();
                }
            }
        });
        this.addElementHandler("else", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                ElseTagAware elseTagAware = (ElseTagAware)xmlHandler.peek();
                ElseTag elseTag = new ElseTag(elseTagAware, xmlHandler.getLocationDetailPath());
                elseTagAware.setElseTag(elseTag);
                xmlHandler.push(elseTag);
            }

            public void appendBody(XMLHandler xmlHandler, String body) {
                RuleStatementContainer self = (RuleStatementContainer)xmlHandler.peek();
                try {
                    self.addRuleStatement(new TextTag(self, xmlHandler.getLocationDetailPath(), body));
                }
                catch (SeasarException ex) {
                    ex.convertSeasarRuntimeException();
                }
            }

            public void end(XMLHandler xmlHandler, String body) {
                ElseTag elseTag = (ElseTag)xmlHandler.pop();
                elseTag.addRuleStatementDone();
            }
        });
        this.addElementHandler("for", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                try {
                    RuleStatementContainer container = (RuleStatementContainer)xmlHandler.peek();
                    String init = attributes.getValue("init");
                    String condition = attributes.getValue("condition");
                    String next = attributes.getValue("next");
                    String label = attributes.getValue("label");
                    String[] initArray = StringUtil.split(init, ";");
                    Expression[] initExps = new Expression[initArray.length];
                    for (int i = 0; i < initArray.length; ++i) {
                        initExps[i] = new RuleParser(initArray[i]).parseExpression();
                    }
                    BooleanExpression conditionExp = new RuleParser(condition).parseBooleanExpression();
                    String[] nextArray = StringUtil.split(next, ";");
                    Expression[] nextExps = new Expression[nextArray.length];
                    for (int i = 0; i < nextArray.length; ++i) {
                        nextExps[i] = new RuleParser(nextArray[i]).parseExpression();
                    }
                    ForTag forTag = new ForTag(container, xmlHandler.getLocationDetailPath(), initExps, conditionExp, nextExps, label);
                    container.addRuleStatement(forTag);
                    xmlHandler.push(forTag);
                }
                catch (SeasarException ex) {
                    Logger.getLogger(this.getClass()).log(ex);
                    ex.convertSeasarRuntimeException();
                }
            }

            public void appendBody(XMLHandler xmlHandler, String body) {
                RuleStatementContainer self = (RuleStatementContainer)xmlHandler.peek();
                try {
                    self.addRuleStatement(new TextTag(self, xmlHandler.getLocationDetailPath(), body));
                }
                catch (SeasarException ex) {
                    ex.convertSeasarRuntimeException();
                }
            }

            public void end(XMLHandler xmlHandler, String body) {
                ForTag forTag = (ForTag)xmlHandler.pop();
                forTag.addRuleStatementDone();
            }
        });
        this.addElementHandler("break", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                RuleStatementContainer container = (RuleStatementContainer)xmlHandler.peek();
                String label = attributes.getValue("label");
                BreakTag breakTag = new BreakTag(container, xmlHandler.getLocationDetailPath(), label);
                container.addRuleStatement(breakTag);
            }
        });
        this.addElementHandler("continue", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                RuleStatementContainer container = (RuleStatementContainer)xmlHandler.peek();
                String label = attributes.getValue("label");
                ContinueTag continueTag = new ContinueTag(container, xmlHandler.getLocationDetailPath(), label);
                container.addRuleStatement(continueTag);
            }
        });
        this.addElementHandler("case", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                RuleStatementContainer container = (RuleStatementContainer)xmlHandler.peek();
                CaseTag caseTag = new CaseTag(container, xmlHandler.getLocationDetailPath());
                container.addRuleStatement(caseTag);
                xmlHandler.push(caseTag);
            }

            public void end(XMLHandler xmlHandler, String body) {
                xmlHandler.pop();
            }
        });
        this.addElementHandler("when", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                try {
                    WhenTagAware whenTagAware = (WhenTagAware)xmlHandler.peek();
                    String condition = attributes.getValue("condition");
                    BooleanExpression conditionExp = new RuleParser(condition).parseBooleanExpression();
                    WhenTag whenTag = new WhenTag(whenTagAware, xmlHandler.getLocationDetailPath(), conditionExp);
                    whenTagAware.addWhenTag(whenTag);
                    xmlHandler.push(whenTag);
                }
                catch (SeasarException ex) {
                    ex.convertSeasarRuntimeException();
                }
            }

            public void appendBody(XMLHandler xmlHandler, String body) {
                RuleStatementContainer self = (RuleStatementContainer)xmlHandler.peek();
                try {
                    self.addRuleStatement(new TextTag(self, xmlHandler.getLocationDetailPath(), body));
                }
                catch (SeasarException ex) {
                    ex.convertSeasarRuntimeException();
                }
            }

            public void end(XMLHandler xmlHandler, String body) {
                WhenTag whenTag = (WhenTag)xmlHandler.pop();
                whenTag.addRuleStatementDone();
            }
        });
        this.addElementHandler("throw", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                try {
                    RuleStatementContainer container = (RuleStatementContainer)xmlHandler.peek();
                    ThrowTag throwTag = new ThrowTag(container, xmlHandler.getLocationDetailPath());
                    String messageCode = attributes.getValue("messageCode");
                    if (messageCode != null) {
                        throwTag.setMessageCode(messageCode);
                        String args = attributes.getValue("args");
                        throwTag.setArgs(args);
                    }
                    container.addRuleStatement(throwTag);
                    xmlHandler.push(throwTag);
                }
                catch (SeasarException ex) {
                    ex.convertSeasarRuntimeException();
                }
            }

            public void end(XMLHandler xmlHandler, String body) {
                try {
                    ThrowTag throwTag = (ThrowTag)xmlHandler.pop();
                    Expression throwableExp = new RuleParser(body).parseExpression();
                    throwTag.setThrowableExp(throwableExp);
                }
                catch (SeasarException ex) {
                    ex.convertSeasarRuntimeException();
                }
            }
        });
        this.addElementHandler("const", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                String name = attributes.getValue("name");
                Assertion.assertTrue(NazunaUtil.isConstName(name), "ESSR0038", null);
                xmlHandler.push(name);
            }

            public void end(XMLHandler xmlHandler, String body) {
                try {
                    String name = (String)xmlHandler.pop();
                    ConstAware parent = (ConstAware)xmlHandler.peek();
                    Expression exp = new RuleParser(body).parseExpression();
                    Object value = exp.evaluateValue(null);
                    parent.addConst(name, value);
                }
                catch (SeasarException ex) {
                    ex.convertSeasarRuntimeException();
                }
            }
        });
        this.addElementHandler("include", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                ConstAware parent = (ConstAware)xmlHandler.peek();
                String className = attributes.getValue("className");
                Map constants = Reflector.getConstants(className);
                parent.addConsts(constants);
            }
        });
        this.addElementHandler("validate", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                RuleBase ruleBase = (RuleBase)xmlHandler.peek();
                ValidateTag requireTag = new ValidateTag(ruleBase, xmlHandler.getLocationDetailPath());
                ruleBase.addRuleStatement(requireTag);
                xmlHandler.push(requireTag);
            }

            public void end(XMLHandler xmlHandler, String body) {
                ValidateTag validateTag = (ValidateTag)xmlHandler.pop();
                validateTag.addRuleStatementDone();
            }
        });
        this.addElementHandler("assert", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                try {
                    RuleStatementContainer container = (RuleStatementContainer)xmlHandler.peek();
                    String condition = attributes.getValue("condition");
                    BooleanExpression conditionExp = new RuleParser(condition).parseBooleanExpression();
                    AssertTag assertTag = new AssertTag(container, xmlHandler.getLocationDetailPath(), conditionExp);
                    String messageCode = attributes.getValue("messageCode");
                    if (messageCode != null) {
                        assertTag.setMessageCode(messageCode);
                        String args = attributes.getValue("args");
                        assertTag.setArgs(args);
                    }
                    container.addRuleStatement(assertTag);
                    xmlHandler.push(assertTag);
                }
                catch (SeasarException ex) {
                    ex.convertSeasarRuntimeException();
                }
            }

            public void end(XMLHandler xmlHandler, String body) {
                try {
                    AssertTag assertTag = (AssertTag)xmlHandler.pop();
                    Expression throwableExp = new RuleParser(body).parseExpression();
                    assertTag.setThrowableExp(throwableExp);
                }
                catch (SeasarException ex) {
                    ex.convertSeasarRuntimeException();
                }
            }
        });
        this.addElementHandler("input", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                RuleBase ruleBase = (RuleBase)xmlHandler.peek();
                InputType inputType = new InputType();
                ruleBase.setInputType(inputType);
                xmlHandler.push(inputType);
            }

            public void end(XMLHandler xmlHandler, String body) {
                xmlHandler.pop();
            }
        });
        this.addElementHandler("output", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                RuleBase ruleBase = (RuleBase)xmlHandler.peek();
                String className = attributes.getValue("className");
                Class clazz = NazunaUtil.getClass(className);
                OutputType outputType = new OutputType(clazz);
                ruleBase.setOutputType(outputType);
            }
        });
        this.addElementHandler("arg", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                InputType inputType = (InputType)xmlHandler.peek();
                String name = attributes.getValue("name");
                String className = attributes.getValue("className");
                Class clazz = NazunaUtil.getClass(className);
                ArgType argType = new ArgType(name, clazz);
                inputType.addArgType(argType);
                xmlHandler.push(argType);
            }

            public void end(XMLHandler xmlHandler, String body) {
                ArgType argType = (ArgType)xmlHandler.pop();
                if (!StringUtil.isEmpty(body)) {
                    try {
                        Expression exp = new RuleParser(body).parseExpression();
                        Object defaultValue = exp.evaluateValue(null);
                        argType.setDefaultValue(defaultValue);
                    }
                    catch (SeasarException ex) {
                        ex.convertSeasarRuntimeException();
                    }
                }
            }
        });
        this.addElementHandler("local", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                RuleBase ruleBase = (RuleBase)xmlHandler.peek();
                LocalType localType = new LocalType();
                ruleBase.setLocalType(localType);
                xmlHandler.push(localType);
            }

            public void end(XMLHandler xmlHandler, String body) {
                xmlHandler.pop();
            }
        });
        this.addElementHandler("var", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                RuleBase ruleBase = (RuleBase)xmlHandler.peek(1);
                LocalType localType = (LocalType)xmlHandler.peek();
                String name = attributes.getValue("name");
                Assertion.assertFalse(ruleBase.containsArgType(name), "ESSR0018", name);
                String className = attributes.getValue("className");
                Class clazz = NazunaUtil.getClass(className);
                VarType varType = new VarType(name, clazz);
                localType.addVarType(varType);
                xmlHandler.push(varType);
            }

            public void end(XMLHandler xmlHandler, String body) {
                VarType varType = (VarType)xmlHandler.pop();
                if (!StringUtil.isEmpty(body)) {
                    try {
                        Expression exp = new RuleParser(body).parseExpression();
                        Object defaultValue = exp.evaluateValue(null);
                        varType.setDefaultValue(defaultValue);
                    }
                    catch (SeasarException ex) {
                        ex.convertSeasarRuntimeException();
                    }
                }
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

