/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.io.File;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.seasar.nazuna.BooleanExpression;
import org.seasar.nazuna.Expression;
import org.seasar.nazuna.FilterDesc;
import org.seasar.nazuna.GroupDesc;
import org.seasar.nazuna.RuleContext;
import org.seasar.nazuna.SortDesc;
import org.seasar.util.Conversion;
import org.seasar.util.Reflector;
import org.seasar.util.SMap;
import org.seasar.util.SeasarException;
import org.seasar.util.SeasarRuntimeException;
import org.seasar.util.StringUtil;

public final class NazunaUtil {
    private static Map _targetClasses = new SMap();
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$math$BigDecimal;

    private NazunaUtil() {
    }

    public static Class getTargetClass(Class clazz) {
        Class ret = (Class)_targetClasses.get(clazz);
        if (ret != null) {
            return ret;
        }
        return clazz;
    }

    public static Object[] getArgs(Expression[] argExps, RuleContext ruleContext) throws SeasarException {
        Object[] args = new Object[argExps.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = argExps[i].evaluateValue(ruleContext);
        }
        return args;
    }

    public static boolean isConstName(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (NazunaUtil.isConstNameChar(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isConstNameChar(char c) {
        return 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_';
    }

    public static boolean isVarArgStartChar(char c) {
        return 'a' <= c && c <= 'z';
    }

    public static boolean isClassName(String targetName) {
        int pos = targetName.lastIndexOf(46) + 1;
        return Character.isUpperCase(targetName.charAt(pos));
    }

    public static Expression[] toExpressionArray(List expList) {
        return expList.toArray(new Expression[expList.size()]);
    }

    public static BooleanExpression[] toBooleanExpressionArray(List boolExpList) {
        return boolExpList.toArray(new BooleanExpression[boolExpList.size()]);
    }

    public static final Object getProperty(Object target, String propertyName) throws SeasarException {
        if (target instanceof Map) {
            return ((Map)target).get(propertyName);
        }
        if (target.getClass().isArray() && "length".equals(propertyName)) {
            return new Integer(Array.getLength(target));
        }
        return Reflector.getProperty(target, propertyName);
    }

    public static final void setProperty(Object target, String propertyName, Object value) throws SeasarException {
        if (target instanceof Map) {
            ((Map)target).put(propertyName, value);
        } else {
            Reflector.setProperty2(target, propertyName, value);
        }
    }

    public static List filter(List items, String condition) throws SeasarException {
        return NazunaUtil.filter(items, condition, null);
    }

    public static List filter(List items, String condition, Map parameters) throws SeasarException {
        FilterDesc filterDesc = new FilterDesc(condition);
        return filterDesc.filter(items, parameters);
    }

    public static Object filterFirst(List items, String condition) throws SeasarException {
        return NazunaUtil.filterFirst(items, condition, null);
    }

    public static Object filterFirst(List items, String condition, Map parameters) throws SeasarException {
        FilterDesc filterDesc = new FilterDesc(condition);
        return filterDesc.filterFirst(items, parameters);
    }

    public static List sort(List items, String clause) throws SeasarException {
        SortDesc sortDesc = new SortDesc(clause);
        return sortDesc.sort(items);
    }

    public static List group(List items, String clause) throws SeasarException {
        GroupDesc groupDesc = new GroupDesc(clause);
        return groupDesc.group(items);
    }

    public static void appendToolsJarPath(StringBuffer buf) {
        String s = System.getProperty("java.home");
        int pos = s.lastIndexOf(File.separator);
        buf.append(s.substring(0, pos));
        buf.append(File.separator);
        buf.append("lib");
        buf.append(File.separator);
        buf.append("tools.jar");
    }

    public static String getToolsJarPath() {
        StringBuffer buf = new StringBuffer();
        NazunaUtil.appendToolsJarPath(buf);
        return buf.toString();
    }

    public static URL getToolsJarURL() {
        try {
            return new File(NazunaUtil.getToolsJarPath()).toURL();
        }
        catch (MalformedURLException ex) {
            throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
        }
    }

    public static Class getClass(String className) {
        if (StringUtil.isEmpty(className)) {
            return class$java$lang$Object == null ? (class$java$lang$Object = NazunaUtil.class$("java.lang.Object")) : class$java$lang$Object;
        }
        if (className.endsWith("[]")) {
            className = "[L" + className.substring(0, className.length() - 2) + ";";
        }
        return Reflector.getClass(className);
    }

    public static final Object adjustValue(Object value, Class valueClass) {
        if (valueClass.isPrimitive()) {
            if (valueClass == Integer.TYPE) {
                return Conversion.toInteger(value);
            }
            if (valueClass == Double.TYPE) {
                return Conversion.toDouble(value);
            }
            if (valueClass == Long.TYPE) {
                return Conversion.toLong(value);
            }
        } else {
            if (valueClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = NazunaUtil.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return Conversion.toInteger(value);
            }
            if (valueClass == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NazunaUtil.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                return Conversion.toBigDecimal(value);
            }
            if (valueClass == (class$java$lang$Long == null ? (class$java$lang$Long = NazunaUtil.class$("java.lang.Long")) : class$java$lang$Long)) {
                return Conversion.toLong(value);
            }
            if (valueClass == (class$java$lang$Double == null ? (class$java$lang$Double = NazunaUtil.class$("java.lang.Double")) : class$java$lang$Double)) {
                return Conversion.toDouble(value);
            }
        }
        return value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _targetClasses.put(class$java$lang$Integer == null ? (class$java$lang$Integer = NazunaUtil.class$("java.lang.Integer")) : class$java$lang$Integer, Integer.TYPE);
        _targetClasses.put(class$java$lang$Long == null ? (class$java$lang$Long = NazunaUtil.class$("java.lang.Long")) : class$java$lang$Long, Long.TYPE);
        _targetClasses.put(class$java$lang$Double == null ? (class$java$lang$Double = NazunaUtil.class$("java.lang.Double")) : class$java$lang$Double, Double.TYPE);
        _targetClasses.put(class$java$lang$Float == null ? (class$java$lang$Float = NazunaUtil.class$("java.lang.Float")) : class$java$lang$Float, Float.TYPE);
        _targetClasses.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = NazunaUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.TYPE);
    }
}

