/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.lang.reflect.Method;
import java.util.Map;
import org.seasar.log.Logger;
import org.seasar.system.ThreadPool;
import org.seasar.util.Reflector;
import org.seasar.util.SMap;
import org.seasar.util.SeasarContext;
import org.seasar.util.SeasarException;
import org.seasar.util.SeasarRuntimeException;

public abstract class NazunaTransAttribute {
    public static final String SUPPORTS_NAME = "Supports";
    public static final String REQUIRED_NAME = "Required";
    public static final String REQUIRES_NEW_NAME = "RequiresNew";
    public static final String MANDATORY_NAME = "Mandatory";
    public static final NazunaTransAttribute SUPPORTS = new Supports();
    public static final NazunaTransAttribute REQUIRED = new Required();
    public static final NazunaTransAttribute REQUIRES_NEW = new RequiresNew();
    public static final NazunaTransAttribute MANDATORY = new Mandatory();
    private static Map _typeMap = new SMap(10);
    private static transient ThreadPool _threadPool;

    protected NazunaTransAttribute() {
    }

    public static NazunaTransAttribute getInstance(String typeName) {
        NazunaTransAttribute type = (NazunaTransAttribute)_typeMap.get(typeName);
        if (type == null) {
            throw new SeasarRuntimeException("ESSR0001", typeName);
        }
        return type;
    }

    public abstract Object invoke(Method var1, Object var2, Object[] var3) throws SeasarException;

    static {
        _typeMap.put(null, SUPPORTS);
        _typeMap.put(SUPPORTS_NAME, SUPPORTS);
        _typeMap.put(REQUIRED_NAME, REQUIRED);
        _typeMap.put(REQUIRES_NEW_NAME, REQUIRES_NEW);
        _typeMap.put(MANDATORY_NAME, MANDATORY);
        _threadPool = new ThreadPool();
    }

    private static class TransactionWork
    implements Runnable {
        private Method _method;
        private Object _target;
        private Object[] _args;
        private Object _ret = null;
        private Throwable _throwable = null;

        TransactionWork(Method method, Object target, Object[] args) {
            this._method = method;
            this._target = target;
            this._args = args;
        }

        public void run() {
            SeasarContext ctx = SeasarContext.getInstance();
            try {
                ctx.begin();
                this._ret = Reflector.invoke(this._method, this._target, this._args);
                ctx.commit();
            }
            catch (Throwable t) {
                this._throwable = t;
                try {
                    if (ctx.hasTransaction()) {
                        ctx.rollback();
                    }
                }
                catch (Throwable t2) {
                    Logger.getLogger(this.getClass()).log(t2);
                }
            }
        }
    }

    private static class Mandatory
    extends NazunaTransAttribute {
        protected Mandatory() {
        }

        public Object invoke(Method method, Object target, Object[] args) throws SeasarException {
            SeasarContext ctx = SeasarContext.getInstance();
            if (!ctx.hasTransaction()) {
                throw new SeasarException("ESSR0311");
            }
            return Reflector.invoke(method, target, args);
        }
    }

    private static class RequiresNew
    extends Required {
        protected RequiresNew() {
        }

        public Object invoke(Method method, Object target, Object[] args) throws SeasarException {
            SeasarContext ctx = SeasarContext.getInstance();
            if (ctx.hasTransaction()) {
                TransactionWork work = new TransactionWork(method, target, args);
                ThreadPool.Worker worker = _threadPool.requestWorker();
                worker.request(work);
                worker.synchronize();
                if (work._throwable != null) {
                    throw SeasarException.convertSeasarException(work._throwable);
                }
                return work._ret;
            }
            return super.invoke(method, target, args);
        }
    }

    private static class Required
    extends NazunaTransAttribute {
        protected Required() {
        }

        public Object invoke(Method method, Object target, Object[] args) throws SeasarException {
            SeasarContext ctx = SeasarContext.getInstance();
            boolean began = false;
            if (!ctx.hasTransaction()) {
                ctx.begin();
                began = true;
            }
            try {
                Object ret = Reflector.invoke(method, target, args);
                if (began) {
                    ctx.commit();
                }
                return ret;
            }
            catch (Throwable t) {
                if (began && ctx.hasTransaction()) {
                    ctx.rollback();
                }
                throw SeasarException.convertSeasarException(t);
            }
        }
    }

    private static class Supports
    extends NazunaTransAttribute {
        protected Supports() {
        }

        public Object invoke(Method method, Object target, Object[] args) throws SeasarException {
            return Reflector.invoke(method, target, args);
        }
    }
}

