/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.seasar.util.Assertion;

public final class NazunaTokenizer {
    public static final int TT_EOF = -1;
    public static final int TT_INTEGER = -11;
    public static final int TT_LONG = -12;
    public static final int TT_DOUBLE = -13;
    public static final int TT_WORD = -3;
    private static final int TT_NOTHING = -4;
    private static final int NEED_CHAR = Integer.MAX_VALUE;
    private static final int QUOTE = 39;
    public int ttype = -4;
    public String sval;
    public Integer ival;
    public Long lval;
    public Double dval;
    private Reader reader = null;
    private char[] buf = new char[20];
    private int peekc = Integer.MAX_VALUE;
    private byte peekct = 0;
    private byte[] ctype = new byte[256];
    private static final byte CT_WHITESPACE = 1;
    private static final byte CT_DIGIT = 2;
    private static final byte CT_ALPHA = 4;

    public NazunaTokenizer(String s) {
        Assertion.assertNotNull("s", s);
        this.reader = new StringReader(s);
        this.wordChars(97, 122);
        this.wordChars(65, 90);
        this.wordChars(48, 57);
        this.wordChars(64, 64);
        this.wordChars(124, 124);
        this.wordChars(95, 95);
        this.wordChars(63, 63);
        this.wordChars(62, 62);
        this.wordChars(61, 61);
        this.wordChars(33, 33);
        this.wordChars(60, 60);
        this.wordChars(58, 58);
        this.wordChars(34, 34);
        this.wordChars(126, 126);
        this.wordChars(42, 42);
        this.ordinaryChar(40);
        this.ordinaryChar(41);
        this.ordinaryChar(43);
        this.ordinaryChar(45);
        this.ordinaryChar(47);
        this.ordinaryChar(37);
        this.ordinaryChar(44);
        this.ordinaryChar(91);
        this.ordinaryChar(93);
        this.ordinaryChar(123);
        this.ordinaryChar(125);
        this.whitespaceChars(0, 32);
        this.parseNumbers();
    }

    public synchronized int nextToken() throws IOException {
        this.initVal();
        if (this.processEOF()) {
            return this.ttype;
        }
        if (this.processWhitespace()) {
            return this.ttype;
        }
        if (this.processDigit()) {
            return this.ttype;
        }
        if (this.processWord()) {
            return this.ttype;
        }
        if (this.processQuote()) {
            return this.ttype;
        }
        if (this.processOrdinary()) {
            return this.ttype;
        }
        this.ttype = this.peekc;
        return this.ttype;
    }

    private int read() throws IOException {
        return this.reader.read();
    }

    private void resetSyntax() {
        int i = this.ctype.length;
        while (--i >= 0) {
            this.ctype[i] = 0;
        }
    }

    private void wordChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= this.ctype.length) {
            hi = this.ctype.length - 1;
        }
        while (low <= hi) {
            int n = low++;
            this.ctype[n] = (byte)(this.ctype[n] | 4);
        }
    }

    private void whitespaceChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= this.ctype.length) {
            hi = this.ctype.length - 1;
        }
        while (low <= hi) {
            this.ctype[low++] = 1;
        }
    }

    private void ordinaryChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= this.ctype.length) {
            hi = this.ctype.length - 1;
        }
        while (low <= hi) {
            this.ctype[low++] = 0;
        }
    }

    private void ordinaryChar(int ch) {
        if (ch >= 0 && ch < this.ctype.length) {
            this.ctype[ch] = 0;
        }
    }

    private void parseNumbers() {
        int i = 48;
        while (i <= 57) {
            int n = i++;
            this.ctype[n] = (byte)(this.ctype[n] | 2);
        }
        this.ctype[46] = (byte)(this.ctype[46] | 2);
        this.ctype[45] = (byte)(this.ctype[45] | 2);
    }

    private void initVal() {
        this.sval = null;
        this.ival = null;
        this.lval = null;
        this.dval = null;
    }

    private boolean processEOF() throws IOException {
        if (this.peekc < 0) {
            this.ttype = -1;
            return true;
        }
        if (this.peekc == Integer.MAX_VALUE) {
            this.peekc = this.read();
            if (this.peekc < 0) {
                this.ttype = -1;
                return true;
            }
        }
        return false;
    }

    private boolean processWhitespace() throws IOException {
        this.peekct = (byte)(this.peekc < 256 ? this.ctype[this.peekc] : 4);
        while ((this.peekct & 1) != 0) {
            if (this.peekc == 13) {
                this.peekc = this.read();
                if (this.peekc == 10) {
                    this.peekc = this.read();
                }
            } else {
                this.peekc = this.read();
            }
            if (this.peekc < 0) {
                this.ttype = -1;
                return true;
            }
            this.peekct = (byte)(this.peekc < 256 ? this.ctype[this.peekc] : 4);
        }
        return false;
    }

    private boolean processDigit() throws IOException {
        if ((this.peekct & 2) != 0) {
            long v2;
            boolean neg = false;
            if (this.peekc == 45) {
                this.peekc = this.read();
                if (this.peekc != 46 && (this.peekc < 48 || this.peekc > 57)) {
                    this.ttype = 45;
                    return true;
                }
                neg = true;
            }
            long v = 0L;
            int decexp = 0;
            int seendot = 0;
            while (true) {
                if (this.peekc == 46 && seendot == 0) {
                    seendot = 1;
                } else {
                    if (48 > this.peekc || this.peekc > 57) break;
                    v = v * 10L + (long)(this.peekc - 48);
                    decexp += seendot;
                }
                this.peekc = this.read();
            }
            long l = v2 = neg ? -v : v;
            if (decexp != 0) {
                this.dval = new Double((double)v2 / Math.pow(10.0, decexp));
                this.ttype = -13;
                return true;
            }
            if (v2 > Integer.MAX_VALUE || v2 < Integer.MIN_VALUE) {
                this.lval = new Long(v2);
                this.ttype = -12;
                return true;
            }
            int v3 = (int)v;
            v3 = neg ? -v3 : v3;
            this.ival = new Integer(v3);
            this.ttype = -11;
            return true;
        }
        return false;
    }

    private boolean processWord() throws IOException {
        if ((this.peekct & 4) != 0) {
            int i = 0;
            do {
                if (i >= this.buf.length) {
                    char[] nb = new char[this.buf.length * 2];
                    System.arraycopy(this.buf, 0, nb, 0, this.buf.length);
                    this.buf = nb;
                }
                this.buf[i++] = (char)this.peekc;
                this.peekc = this.read();
                int n = this.peekc < 0 ? 1 : (this.peekct = this.peekc < 256 ? this.ctype[this.peekc] : 4);
            } while ((this.peekct & 6) != 0);
            this.sval = String.copyValueOf(this.buf, 0, i);
            this.ttype = -3;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processQuote() throws IOException {
        int d;
        if (this.peekc != 39) {
            return false;
        }
        this.ttype = 39;
        int i = 0;
        int c = d = this.read();
        while (d >= 0) {
            block6: {
                if (d == 39) {
                    int d2 = this.read();
                    if (d2 == 39) {
                        c = 39;
                        break block6;
                    } else {
                        d = d2;
                        break;
                    }
                }
                c = d;
            }
            if (i >= this.buf.length) {
                char[] nb = new char[this.buf.length * 2];
                System.arraycopy(this.buf, 0, nb, 0, this.buf.length);
                this.buf = nb;
            }
            this.buf[i++] = (char)c;
            d = this.read();
        }
        this.peekc = d;
        this.sval = String.copyValueOf(this.buf, 0, i);
        return true;
    }

    private boolean processOrdinary() throws IOException {
        if (this.peekct == 0) {
            this.ttype = this.peekc;
            this.peekc = this.read();
            this.peekct = this.peekc < 0 ? 1 : (this.peekc < 256 ? this.ctype[this.peekc] : 4);
            return true;
        }
        return false;
    }
}

