/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.util.Map;
import org.seasar.nazuna.LocalLocation;
import org.seasar.nazuna.NazunaLocation;
import org.seasar.nazuna.NazunaURL;
import org.seasar.nazuna.RemoteLocation;
import org.seasar.util.Assertion;
import org.seasar.util.ElementHandler;
import org.seasar.util.ResourceUtil;
import org.seasar.util.SMap;
import org.seasar.util.XMLHandler;
import org.seasar.util.XMLHandlerParser;
import org.seasar.util.XMLHandlerRule;
import org.xml.sax.Attributes;

public final class NazunaRemoting {
    private static XMLHandlerRule _xmlHandlerRule = new XMLHandlerRule();
    private static Map _locationsByName = new SMap();
    private static Map _locationsByRuleName = new SMap();
    private static LocalLocation _localLocation = new LocalLocation();
    private static NazunaLocation _defaultLocation = _localLocation;

    private NazunaRemoting() {
    }

    public static final NazunaLocation getLocationByName(String name) {
        NazunaLocation location = (NazunaLocation)_locationsByName.get(name);
        Assertion.assertFound(name, location);
        return location;
    }

    public static final NazunaLocation getLocationByRuleName(String ruleName) {
        NazunaLocation location = (NazunaLocation)_locationsByRuleName.get(ruleName);
        if (location != null) {
            return location;
        }
        return _defaultLocation;
    }

    public static final NazunaLocation getDefaultLocation() {
        return _defaultLocation;
    }

    public static final NazunaLocation getLocalLocation() {
        return _localLocation;
    }

    public static final void setDefaultLocation(String name) {
        Assertion.assertNotNull("name", name);
        _defaultLocation = NazunaRemoting.getLocationByName(name);
    }

    public static final void addRemoteLocation(RemoteLocation remoteLocation) {
        Assertion.assertNotNull("remoteLocation", remoteLocation);
        _locationsByName.put(remoteLocation.getName(), remoteLocation);
    }

    public static final void addRuleLocation(String ruleName, String name) {
        Assertion.assertNotNull("ruleName", ruleName);
        Assertion.assertNotNull("name", name);
        _locationsByRuleName.put(ruleName, NazunaRemoting.getLocationByName(name));
    }

    public static final void configure(String fileName) {
        NazunaRemoting.init();
        if (ResourceUtil.isExist(fileName)) {
            XMLHandlerParser.parse(fileName, _xmlHandlerRule);
        }
    }

    public static final void init() {
        _locationsByName.clear();
        _locationsByRuleName.clear();
        _locationsByName.put("local", _localLocation);
    }

    private static void setupXMLHandlerRule() {
        _xmlHandlerRule.addElementHandler("/nazuna-remoting/remote", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                String name = attributes.getValue("name");
                RemoteLocation remoteLocation = new RemoteLocation(name);
                NazunaRemoting.addRemoteLocation(remoteLocation);
                xmlHandler.push(remoteLocation);
            }

            public void end(XMLHandler xmlHandler, String body) {
                xmlHandler.pop();
            }
        });
        _xmlHandlerRule.addElementHandler("/nazuna-remoting/remote/url", new ElementHandler(){

            public void end(XMLHandler xmlHandler, String body) {
                RemoteLocation loc = (RemoteLocation)xmlHandler.peek();
                NazunaURL url = new NazunaURL(body);
                loc.addURL(url);
            }
        });
        _xmlHandlerRule.addElementHandler("/nazuna-remoting/default", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                String locationName = attributes.getValue("location");
                NazunaRemoting.setDefaultLocation(locationName);
            }
        });
        _xmlHandlerRule.addElementHandler("/nazuna-remoting/rule", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                String ruleName = attributes.getValue("name");
                String locationName = attributes.getValue("location");
                NazunaRemoting.addRuleLocation(ruleName, locationName);
            }
        });
    }

    static {
        NazunaRemoting.setupXMLHandlerRule();
        NazunaRemoting.configure("/nazuna-remoting.xml");
    }
}

