/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import org.seasar.nazuna.AliasConfig;
import org.seasar.nazuna.NazunaConfig;
import org.seasar.util.ElementHandler;
import org.seasar.util.XMLHandler;
import org.seasar.util.XMLHandlerParser;
import org.seasar.util.XMLHandlerRule;
import org.xml.sax.Attributes;

public final class NazunaConfigBuilder {
    private static XMLHandlerRule _xmlHandlerRule = new XMLHandlerRule();

    private static void configure() {
        NazunaConfigBuilder.setupXMLHandlerRule();
    }

    private NazunaConfigBuilder() {
    }

    public static final NazunaConfig parse(String xmlFileName) {
        return (NazunaConfig)XMLHandlerParser.parse(xmlFileName, _xmlHandlerRule);
    }

    private static void setupXMLHandlerRule() {
        _xmlHandlerRule.addElementHandler("/nazuna", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                xmlHandler.push(new NazunaConfig());
            }
        });
        _xmlHandlerRule.addElementHandler("/nazuna/aliases/alias", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                NazunaConfig nazunaConfig = (NazunaConfig)xmlHandler.peek();
                String name = attributes.getValue("name");
                String className = attributes.getValue("className");
                String methodName = attributes.getValue("methodName");
                AliasConfig aliasConfig = new AliasConfig(name, className, methodName);
                nazunaConfig.addAliasConfig(aliasConfig);
            }
        });
    }

    static {
        NazunaConfigBuilder.configure();
    }
}

