/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import org.seasar.nazuna.Expression;
import org.seasar.nazuna.RuleContext;
import org.seasar.nazuna.RuleTokenizer;
import org.seasar.util.Assertion;
import org.seasar.util.MathUtil;
import org.seasar.util.SeasarException;

public final class MultDivModExp
implements Expression {
    private final Expression _arg1Exp;
    private final Expression _arg2Exp;
    private int _token;

    public MultDivModExp(Expression arg1Exp, Expression arg2Exp, int token) {
        Assertion.assertNotNull("arg1Exp", arg1Exp);
        Assertion.assertNotNull("arg2Exp", arg2Exp);
        Assertion.assertTrue(token == 13 || token == 14 || token == 15, "ESSR0003", "token", RuleTokenizer.getTokenName(token));
        this._arg1Exp = arg1Exp;
        this._arg2Exp = arg2Exp;
        this._token = token;
    }

    public Object evaluateValue(RuleContext ruleContext) throws SeasarException {
        Number arg1 = (Number)this._arg1Exp.evaluateValue(ruleContext);
        Number arg2 = (Number)this._arg2Exp.evaluateValue(ruleContext);
        switch (this._token) {
            case 13: {
                return MathUtil.multiply(arg1, arg2);
            }
            case 14: {
                return MathUtil.divide(arg1, arg2);
            }
        }
        return MathUtil.mod(arg1, arg2);
    }
}

