/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.seasar.nazuna.Expression;
import org.seasar.nazuna.NazunaUtil;
import org.seasar.nazuna.RuleContext;
import org.seasar.util.Assertion;
import org.seasar.util.Reflector;
import org.seasar.util.SeasarException;
import org.seasar.util.StringUtil;

public final class MethodExp
implements Expression {
    private final String _targetName;
    private Class _targetClass;
    private String[] _names;
    private final String _methodName;
    private final Expression[] _exps;

    public MethodExp(String targetName, String methodName, Expression[] exps) {
        Assertion.assertNotNull("targetName", targetName);
        Assertion.assertNotNull("methodName", methodName);
        Assertion.assertNotNull("exps", exps);
        this._targetName = targetName;
        if (NazunaUtil.isClassName(targetName)) {
            this._targetClass = Reflector.getClass(targetName);
        } else {
            this._names = StringUtil.split(targetName, ".");
        }
        this._methodName = methodName;
        this._exps = exps;
    }

    public Object evaluateValue(RuleContext ruleContext) throws SeasarException {
        Object[] args = NazunaUtil.getArgs(this._exps, ruleContext);
        if (this._targetClass != null) {
            return this.invoke(this._targetClass, null, args);
        }
        Object target = ruleContext.getValue(this._names[0]);
        for (int i = 1; i < this._names.length; ++i) {
            target = NazunaUtil.getProperty(target, this._names[i]);
        }
        return this.invoke(target.getClass(), target, args);
    }

    private Object invoke(Class clazz, Object target, Object[] args) throws SeasarException {
        List methods = Reflector.getMethods(clazz, this._methodName);
        return this.invoke(methods, target, args);
    }

    private Object invoke(List methods, Object target, Object[] args) throws SeasarException {
        block0: for (int i = 0; i < methods.size(); ++i) {
            Method method = (Method)methods.get(i);
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length != args.length) continue;
            for (int j = 0; j < args.length; ++j) {
                if (args[j] != null && !paramTypes[j].isAssignableFrom(NazunaUtil.getTargetClass(args[j].getClass()))) continue block0;
            }
            return this.invoke(method, target, args);
        }
        throw new SeasarException("ESSR0001", new Object[]{this._methodName});
    }

    private Object invoke(Method method, Object target, Object[] args) throws SeasarException {
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException ex) {
            throw SeasarException.convertSeasarException(ex.getCause());
        }
        catch (IllegalAccessException ex) {
            throw SeasarException.convertSeasarException(ex);
        }
    }
}

