/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import org.seasar.nazuna.BooleanExpression;
import org.seasar.nazuna.Expression;
import org.seasar.nazuna.RuleContext;
import org.seasar.util.Assertion;
import org.seasar.util.Conversion;
import org.seasar.util.RegExp;
import org.seasar.util.SeasarException;

public final class MatchExp
implements BooleanExpression {
    private final Expression _targetExp;
    private final Expression _patternExp;
    private boolean _ignoreCase = false;

    public MatchExp(Expression targetExp, Expression patternExp) {
        this(targetExp, patternExp, false);
    }

    public MatchExp(Expression targetExp, Expression patternExp, boolean ignoreCase) {
        Assertion.assertNotNull("targetExp", targetExp);
        Assertion.assertNotNull("patternExp", patternExp);
        this._targetExp = targetExp;
        this._patternExp = patternExp;
        this._ignoreCase = ignoreCase;
    }

    public boolean evaluate(RuleContext ruleContext) throws SeasarException {
        String target = Conversion.toString(this._targetExp.evaluateValue(ruleContext), null);
        if (target == null) {
            return false;
        }
        String pattern = Conversion.toString(this._patternExp.evaluateValue(ruleContext), null);
        if (this._ignoreCase) {
            return RegExp.matchIgnoreCase(pattern, target);
        }
        return RegExp.match(pattern, target);
    }
}

