/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import org.seasar.nazuna.BooleanExpression;
import org.seasar.nazuna.Expression;
import org.seasar.nazuna.RuleContext;
import org.seasar.util.Assertion;
import org.seasar.util.Conversion;
import org.seasar.util.Like;
import org.seasar.util.SeasarException;

public final class LikeExp
implements BooleanExpression {
    private final Expression _targetExp;
    private final Expression _patternExp;

    public LikeExp(Expression targetExp, Expression patternExp) {
        Assertion.assertNotNull("targetExp", targetExp);
        Assertion.assertNotNull("patternExp", patternExp);
        this._targetExp = targetExp;
        this._patternExp = patternExp;
    }

    public boolean evaluate(RuleContext ruleContext) throws SeasarException {
        String target = Conversion.toString(this._targetExp.evaluateValue(ruleContext), null);
        String pattern = Conversion.toString(this._patternExp.evaluateValue(ruleContext), null);
        return Like.match(pattern, target);
    }
}

