/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.util.Map;
import org.seasar.nazuna.Arg;
import org.seasar.nazuna.ArgType;
import org.seasar.nazuna.NazunaUtil;
import org.seasar.util.Assertion;
import org.seasar.util.EMap;
import org.seasar.util.SMap;
import org.seasar.util.SeasarException;

public final class InputType {
    private EMap _argTypes = new EMap();

    public final void addArgType(ArgType argType) {
        Assertion.assertNotNull("argType", argType);
        String name = argType.getName();
        Assertion.assertNotExist(name, this._argTypes.put(name, argType));
    }

    public final int getArgTypeSize() {
        return this._argTypes.size();
    }

    public final ArgType getArgType(String name) {
        return (ArgType)this._argTypes.get(name);
    }

    public final ArgType getArgType(int index) {
        return (ArgType)this._argTypes.get(index);
    }

    public final boolean containsArgType(String name) {
        return this._argTypes.containsKey(name);
    }

    public final Map createArgs(Map parameters) throws SeasarException {
        SMap args = new SMap();
        if (parameters == null) {
            for (int i = 0; i < this._argTypes.size(); ++i) {
                ArgType argType = (ArgType)this._argTypes.get(i);
                args.put(argType.getName(), new Arg(argType));
            }
        } else {
            for (int i = 0; i < this._argTypes.size(); ++i) {
                ArgType argType = (ArgType)this._argTypes.get(i);
                if (parameters.containsKey(argType.getName())) {
                    Object value = parameters.get(argType.getName());
                    args.put(argType.getName(), new Arg(argType, value));
                    continue;
                }
                args.put(argType.getName(), new Arg(argType));
            }
        }
        return args;
    }

    public final Map convertArgsToMap(Object[] args) {
        SMap argMap = new SMap();
        for (int i = 0; i < args.length; ++i) {
            ArgType argType = this.getArgType(i);
            Object value = NazunaUtil.adjustValue(args[i], argType.getArgClass());
            argMap.put(argType.getName(), value);
        }
        return argMap;
    }
}

