/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import org.seasar.nazuna.BooleanExpression;
import org.seasar.nazuna.Expression;
import org.seasar.nazuna.RuleContext;
import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class InExp
implements BooleanExpression {
    private Expression _targetExp;
    private Expression[] _inExps;

    public InExp(Expression targetExp, Expression[] inExps) {
        Assertion.assertNotNull("targetExp", targetExp);
        Assertion.assertNotNull("inExps", inExps);
        this._targetExp = targetExp;
        this._inExps = inExps;
    }

    public boolean evaluate(RuleContext ruleContext) throws SeasarException {
        Comparable target = (Comparable)this._targetExp.evaluateValue(ruleContext);
        if (target == null) {
            return false;
        }
        for (int i = 0; i < this._inExps.length; ++i) {
            Expression inArgExp = this._inExps[i];
            Comparable inArg = (Comparable)inArgExp.evaluateValue(ruleContext);
            if (inArg == null || target.compareTo(inArg) != 0) continue;
            return true;
        }
        return false;
    }
}

