/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.math.BigDecimal;
import org.seasar.nazuna.GroupElement;
import org.seasar.nazuna.NazunaUtil;
import org.seasar.util.Assertion;
import org.seasar.util.Conversion;
import org.seasar.util.MathUtil;
import org.seasar.util.SeasarException;

public abstract class GroupValue {
    private GroupElement _groupElement;

    public GroupValue(GroupElement groupElement) {
        Assertion.assertNotNull("groupElement", groupElement);
        this._groupElement = groupElement;
    }

    public GroupElement getGroupElement() {
        return this._groupElement;
    }

    public abstract void calculate(Object var1) throws SeasarException;

    public abstract Object getValue();

    public static final class AvgValue
    extends GroupValue {
        private GroupValue _sumValue;
        private GroupValue _countValue;

        public AvgValue(GroupElement groupElement) {
            super(groupElement);
            this._sumValue = new SumValue(groupElement);
            this._countValue = new CountValue(groupElement);
        }

        public void calculate(Object item) throws SeasarException {
            this._sumValue.calculate(item);
            this._countValue.calculate(item);
        }

        public Object getValue() {
            double sum = Conversion.toBigDecimal(this._sumValue.getValue()).doubleValue();
            double count = Conversion.toBigDecimal(this._countValue.getValue()).doubleValue();
            if (count != 0.0) {
                return new BigDecimal(sum / count);
            }
            return null;
        }
    }

    public static final class MinValue
    extends GroupValue {
        private Comparable _value = null;

        public MinValue(GroupElement groupElement) {
            super(groupElement);
        }

        public void calculate(Object item) throws SeasarException {
            String groupedAttributeName = this.getGroupElement().getGroupedPropertyName();
            Comparable val = (Comparable)NazunaUtil.getProperty(item, groupedAttributeName);
            this._value = MathUtil.min(this._value, val);
        }

        public Object getValue() {
            return this._value;
        }
    }

    public static final class MaxValue
    extends GroupValue {
        private Comparable _value = null;

        public MaxValue(GroupElement groupElement) {
            super(groupElement);
        }

        public void calculate(Object item) throws SeasarException {
            String groupedAttributeName = this.getGroupElement().getGroupedPropertyName();
            Comparable val = (Comparable)NazunaUtil.getProperty(item, groupedAttributeName);
            this._value = MathUtil.max(this._value, val);
        }

        public Object getValue() {
            return this._value;
        }
    }

    public static final class SumValue
    extends GroupValue {
        private BigDecimal _value = MathUtil.ZERO_BIGDECIMAL;

        public SumValue(GroupElement groupElement) {
            super(groupElement);
        }

        public void calculate(Object item) throws SeasarException {
            String groupedAttributeName = this.getGroupElement().getGroupedPropertyName();
            BigDecimal val = Conversion.toBigDecimal(NazunaUtil.getProperty(item, groupedAttributeName));
            this._value = MathUtil.sum(this._value, val);
        }

        public Object getValue() {
            return this._value;
        }
    }

    public static final class CountValue
    extends GroupValue {
        private int _count = 0;

        public CountValue(GroupElement groupElement) {
            super(groupElement);
        }

        public void calculate(Object item) throws SeasarException {
            String groupedAttributeName = this.getGroupElement().getGroupedPropertyName();
            if (groupedAttributeName == null) {
                ++this._count;
            } else {
                Object val = NazunaUtil.getProperty(item, groupedAttributeName);
                System.out.println(val);
                if (val != null) {
                    ++this._count;
                }
            }
        }

        public Object getValue() {
            return new Integer(this._count);
        }
    }
}

