/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import org.seasar.nazuna.GroupElement;
import org.seasar.nazuna.GroupValue;

public abstract class GroupType {
    public static final GroupType SUM = new SumType();
    public static final GroupType MAX = new MaxType();
    public static final GroupType MIN = new MinType();
    public static final GroupType COUNT = new CountType();
    public static final GroupType AVG = new AvgType();

    private GroupType() {
    }

    public abstract GroupValue newGroupValue(GroupElement var1);

    private static class AvgType
    extends GroupType {
        private AvgType() {
        }

        public GroupValue newGroupValue(GroupElement groupElement) {
            return new GroupValue.AvgValue(groupElement);
        }
    }

    private static class CountType
    extends GroupType {
        private CountType() {
        }

        public GroupValue newGroupValue(GroupElement groupElement) {
            return new GroupValue.CountValue(groupElement);
        }
    }

    private static class MinType
    extends GroupType {
        private MinType() {
        }

        public GroupValue newGroupValue(GroupElement groupElement) {
            return new GroupValue.MinValue(groupElement);
        }
    }

    private static class MaxType
    extends GroupType {
        private MaxType() {
        }

        public GroupValue newGroupValue(GroupElement groupElement) {
            return new GroupValue.MaxValue(groupElement);
        }
    }

    private static class SumType
    extends GroupType {
        private SumType() {
        }

        public GroupValue newGroupValue(GroupElement groupElement) {
            return new GroupValue.SumValue(groupElement);
        }
    }
}

