/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.util.Arrays;
import java.util.List;
import org.seasar.nazuna.GroupElement;
import org.seasar.nazuna.GroupType;
import org.seasar.nazuna.GroupValue;
import org.seasar.nazuna.NazunaUtil;
import org.seasar.nazuna.RuleTokenizer;
import org.seasar.nazuna.SortDesc;
import org.seasar.nazuna.SortElement;
import org.seasar.util.Assertion;
import org.seasar.util.EArrayList;
import org.seasar.util.EMap;
import org.seasar.util.SeasarException;

public final class GroupDesc {
    private String[] _keys;
    private GroupElement[] _groupElements;

    public GroupDesc(String clause) throws SeasarException {
        Assertion.assertNotNull("clause", clause);
        EArrayList keyList = new EArrayList();
        EArrayList groupElementList = new EArrayList();
        RuleTokenizer tokenizer = new RuleTokenizer(clause);
        int token = tokenizer.nextToken();
        while (token != 99) {
            switch (token) {
                case 4: {
                    String key = tokenizer.getString();
                    keyList.add(key);
                    token = tokenizer.nextToken();
                    break;
                }
                default: {
                    String propertyName = "_" + groupElementList.size();
                    GroupType groupType = null;
                    String groupedPropertyName = null;
                    switch (token) {
                        case 71: {
                            groupType = GroupType.COUNT;
                            break;
                        }
                        case 72: {
                            groupType = GroupType.SUM;
                            break;
                        }
                        case 73: {
                            groupType = GroupType.MAX;
                            break;
                        }
                        case 74: {
                            groupType = GroupType.MIN;
                            break;
                        }
                        case 75: {
                            groupType = GroupType.AVG;
                            break;
                        }
                        default: {
                            throw new SeasarException("ESSR0022", new Object[]{RuleTokenizer.getTokenName(token)});
                        }
                    }
                    tokenizer.nextToken(9);
                    token = tokenizer.nextToken();
                    if (token != 13 || !groupType.equals(GroupType.COUNT)) {
                        groupedPropertyName = tokenizer.getString();
                    }
                    tokenizer.nextToken(10);
                    token = tokenizer.nextToken();
                    switch (token) {
                        case 76: {
                            tokenizer.nextToken();
                            propertyName = tokenizer.getString();
                            token = tokenizer.nextToken();
                            break;
                        }
                        case 22: 
                        case 99: {
                            break;
                        }
                        default: {
                            propertyName = tokenizer.getString();
                            token = tokenizer.nextToken();
                        }
                    }
                    GroupElement groupElement = new GroupElement(propertyName, groupType, groupedPropertyName);
                    groupElementList.add(groupElement);
                }
            }
            if (token != 22) continue;
            token = tokenizer.nextToken();
        }
        this._keys = keyList.toArray((T[])new String[keyList.size()]);
        this._groupElements = groupElementList.toArray((T[])new GroupElement[groupElementList.size()]);
    }

    public GroupDesc(String[] keys, GroupElement[] groupElements) {
        Assertion.assertNotNull("keys", keys);
        Assertion.assertNotNull("groupElements", groupElements);
        this._keys = keys;
        this._groupElements = groupElements;
    }

    public String[] getKeys() {
        return this._keys;
    }

    public GroupElement[] getGroupElements() {
        return this._groupElements;
    }

    public List group(List items) throws SeasarException {
        Assertion.assertNotNull("items", items);
        Calculator calculator = new Calculator(items);
        return calculator.calculate();
    }

    private SortDesc getSortDesc() {
        SortElement[] sortElements = new SortElement[this._keys.length];
        for (int i = 0; i < this._keys.length; ++i) {
            sortElements[i] = new SortElement(this._keys[i]);
        }
        return new SortDesc(sortElements);
    }

    private GroupValue[] getGroupValues() {
        GroupValue[] groupValues = new GroupValue[this._groupElements.length];
        for (int i = 0; i < this._groupElements.length; ++i) {
            groupValues[i] = this._groupElements[i].newGroupValue();
        }
        return groupValues;
    }

    private class ValueCalculator {
        private Object[] _keyValues;
        private GroupValue[] _groupValues;

        private ValueCalculator(Object[] keyValues) {
            this._keyValues = keyValues;
            this._groupValues = GroupDesc.this.getGroupValues();
        }

        void calculate(Object item) throws SeasarException {
            for (int i = 0; i < this._groupValues.length; ++i) {
                this._groupValues[i].calculate(item);
            }
        }

        EMap getGroupedItem() throws SeasarException {
            int i;
            EMap groupedItem = new EMap();
            for (i = 0; i < GroupDesc.this._keys.length; ++i) {
                groupedItem.put(GroupDesc.this._keys[i], this._keyValues[i]);
            }
            for (i = 0; i < this._groupValues.length; ++i) {
                groupedItem.put(this._groupValues[i].getGroupElement().getPropertyName(), this._groupValues[i].getValue());
            }
            return groupedItem;
        }
    }

    private final class Calculator {
        private List _items;

        public Calculator(List items) {
            SortDesc sortDesc = GroupDesc.this.getSortDesc();
            this._items = sortDesc.sort(items);
        }

        public List calculate() throws SeasarException {
            EArrayList ret = new EArrayList();
            if (this._items.size() == 0) {
                return ret;
            }
            Object item = this._items.get(0);
            Object[] prevKeyValues = this.getKeyValues(item);
            ValueCalculator valueCalculator = new ValueCalculator(prevKeyValues);
            valueCalculator.calculate(item);
            for (int i = 1; i < this._items.size(); ++i) {
                item = this._items.get(i);
                Object[] keyValues = this.getKeyValues(item);
                if (!Arrays.equals(keyValues, prevKeyValues)) {
                    ret.add(valueCalculator.getGroupedItem());
                    prevKeyValues = keyValues;
                    valueCalculator = new ValueCalculator(prevKeyValues);
                }
                valueCalculator.calculate(item);
            }
            ret.add(valueCalculator.getGroupedItem());
            return ret;
        }

        private Object[] getKeyValues(Object item) throws SeasarException {
            Object[] keyValues = new Object[GroupDesc.this._keys.length];
            for (int i = 0; i < GroupDesc.this._keys.length; ++i) {
                keyValues[i] = NazunaUtil.getProperty(item, GroupDesc.this._keys[i]);
            }
            return keyValues;
        }
    }
}

