/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.util.Map;
import org.seasar.nazuna.Flowlet;
import org.seasar.nazuna.FlowletDeployer;
import org.seasar.nazuna.InputType;
import org.seasar.nazuna.NazunaConstants;
import org.seasar.util.SMap;
import org.seasar.util.SeasarException;

public final class FlowletContainer {
    private static Map _flowletDeployers = new SMap(89);

    private FlowletContainer() {
    }

    public static final Object execute(String name, Object[] args) throws SeasarException {
        Flowlet flowlet;
        InputType inputType;
        if (args == null) {
            args = NazunaConstants.NULL_ARGS;
        }
        if ((inputType = (flowlet = FlowletContainer.getFlowlet(name)).getInputType()) == null) {
            return flowlet.execute();
        }
        return flowlet.execute(inputType.convertArgsToMap(args));
    }

    public static final Object execute(String name, Map parameters) throws SeasarException {
        return FlowletContainer.getFlowlet(name).execute(parameters);
    }

    public static Flowlet getFlowlet(String name) throws SeasarException {
        FlowletDeployer deployer = FlowletContainer.getFlowletDeployer(name);
        deployer.deploy();
        return deployer.getFlowlet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlowletDeployer getFlowletDeployer(String name) throws SeasarException {
        FlowletDeployer deployer = (FlowletDeployer)_flowletDeployers.get(name = name.intern());
        if (deployer != null) {
            return deployer;
        }
        Map map = _flowletDeployers;
        synchronized (map) {
            deployer = (FlowletDeployer)_flowletDeployers.get(name);
            if (deployer == null) {
                deployer = new FlowletDeployer(name);
                _flowletDeployers.put(name, deployer);
            }
        }
        return deployer;
    }
}

