/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.io.File;
import java.net.URL;
import org.seasar.nazuna.Flowlet;
import org.seasar.nazuna.NazunaTransAttribute;
import org.seasar.nazuna.NazunaXMLHandlerRule;
import org.seasar.util.ElementHandler;
import org.seasar.util.XMLHandler;
import org.seasar.util.XMLHandlerParser;
import org.seasar.util.XMLHandlerRule;
import org.xml.sax.Attributes;

public final class FlowletBuilder {
    private static XMLHandlerRule _xmlHandlerRule = new NazunaXMLHandlerRule();

    private static void configure() {
        FlowletBuilder.setupXMLHandlerRule();
    }

    private FlowletBuilder() {
    }

    public static final Flowlet parse(String path) {
        return (Flowlet)XMLHandlerParser.parse(path, _xmlHandlerRule, false);
    }

    public static final Flowlet parse(URL url) {
        return (Flowlet)XMLHandlerParser.parse(url, _xmlHandlerRule, false);
    }

    public static final Flowlet parse(File file) {
        return (Flowlet)XMLHandlerParser.parse(file, _xmlHandlerRule, false);
    }

    private static void setupXMLHandlerRule() {
        _xmlHandlerRule.addElementHandler("flowlet", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                Flowlet flowlet = new Flowlet();
                String transAttributeName = attributes.getValue("transAttribute");
                NazunaTransAttribute transAttribute = NazunaTransAttribute.getInstance(transAttributeName);
                flowlet.setTransAttribute(transAttribute);
                xmlHandler.push(flowlet);
            }

            public void end(XMLHandler xmlHandler, String body) {
                Flowlet rule = (Flowlet)xmlHandler.peek();
                rule.addRuleStatementDone();
            }
        });
    }

    static {
        FlowletBuilder.configure();
    }
}

