/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import org.seasar.nazuna.NazunaUtil;
import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class ArgType {
    private String _name;
    private Class _argClass;
    private Object _defaultValue;

    public ArgType(String name, Class argClass) {
        Assertion.assertNotNull("name", name);
        Assertion.assertTrue(NazunaUtil.isVarArgStartChar(name.charAt(0)), "ESSR0036", null);
        Assertion.assertNotNull("argClass", argClass);
        this._name = name;
        this._argClass = argClass;
    }

    public String getName() {
        return this._name;
    }

    public Class getArgClass() {
        return this._argClass;
    }

    public Object getDefaultValue() throws SeasarException {
        return this._defaultValue;
    }

    public final void setDefaultValue(Object defaultValue) throws SeasarException {
        this.validate(defaultValue);
        this._defaultValue = defaultValue;
    }

    public void validate(Object value) throws SeasarException {
        if (value != null && !this._argClass.isInstance(value)) {
            throw new SeasarException("ESSR0002", new Object[]{this._name, this._argClass.getName(), value.getClass().getName()});
        }
    }
}

